% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apis_functions.R
\name{inla.st}
\alias{inla.st}
\title{Space-time bayesian INLA estimator}
\usage{
inla.st(
  formula,
  d,
  W,
  RHO,
  PHI,
  var.agg,
  normalization = FALSE,
  improve = TRUE,
  fhyper = NULL,
  probit = FALSE,
  ...
)
}
\arguments{
\item{formula}{Formula of the model to be estimated}

\item{d}{Data frame}

\item{W}{Spatial matrix}

\item{RHO}{Parameter of spatial dependence}

\item{PHI}{Parameter of temporal dependence}

\item{var.agg}{Indexes of the panel dimensions. The first argument is the spatial dimension, the second argument is the temporal dimension.}

\item{normalization}{Boolean. If TRUE the data are normalized before estimation}

\item{improve}{Please refer to the documentation of the INLA package}

\item{fhyper}{Plase refer to the documentation of the INLA package}

\item{probit}{Plase refer to the documentation of the INLA package}

\item{...}{additional parameters. Please, refer to the documentation of the INLA package}
}
\value{
Returns a model of class "inla". Please, refer to the documentation of the INLA package for additional information
}
\description{
This function estimates a space time linear model using the bayesian INLA. It is a wrapper of the INLA::inla function (Lindgren and Rue (2015) \doi{10.18637/jss.v063.i19}; Bivand, Gomez-Rubio and Rue (2015) \doi{10.18637/jss.v063.i20}) adapted to panel data.
}
\examples{
\donttest{
library(rgdal)
set.seed(123)
sd = sim_data_fe(dataset=regsamp,N=100,TT=8,spatial = 80,
                 Tau = -0.2,Rho = 0.4, Beta = 2,sdDev = 2,
                 startingT = 10,LONGLAT = TRUE)
est_inla = inla.st(formula = Y~-1+X1,d = sd[[1]]@data,
               W = sd[[2]],PHI=-0.2,RHO=0.4,
               var.agg=c('Cod_Provincia','Anno'),
               family='gaussian',
               improve=TRUE,
               normalization=FALSE,
               control.family = list(hyper = list(prec=list(initial=25,fixed=TRUE))),
               control.predictor = list(compute = TRUE),
               control.compute = list(dic = TRUE, cpo = TRUE),
               control.inla = list(print.joint.hyper = TRUE))
summary(est_inla)
}

}
