% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wkm.R
\name{wkm}
\alias{wkm}
\title{wkm}
\usage{
wkm(times, data, param = list(alpha = 1, var = TRUE, cov = FALSE, left.limit =
  FALSE, rr.subset = rep(TRUE, nrow(data))), formula = NULL)
}
\arguments{
\item{times}{a vector of evaluation times}

\item{data}{data frame containing the variables in formula (if is.null(formula) expected column names are: Y (time), D (status), W (strat. factor), V (left-truncation times))}

\item{param}{list of parameters containing:
alpha: fractional parameter (default=1)
var: if TRUE (default) calculate variance estimate
cov: if FALSE (default) do not calculate covariance matrix estimate
left.limit: if TRUE calculate left-continuous estimates, else calculate right-continuous estimates
rr.subset: logical vector defining subset of observations to use for response rate estimation (default: use all observations)}

\item{formula}{an object of class '"formula"' specifying the conditional survival model (only discrete covariates supported)}
}
\value{
an object of class '"wkm"'
}
\description{
Weighted Kaplan-Meier estimator with discrete time-independent covariate
}
\details{
This function calculates the weighted Kaplan-Meier estimator for the survival function with weights based on a discrete time-independent covariate as described in Murray/Tsiatis (1996).
The survival probabilities are evaluated at each entry in the vector \code{times}. The data frame \code{data} must either contain the variable in \code{formula} or, if \code{formula} is \code{NULL},
the variables \code{V} (left-truncation time), \code{Y} (censored failure time), \code{D} (censoring indicator), \code{W} (stratification variable).
If \code{var} is \code{TRUE} then an estimate of the asmyptotic variance is calculated for each entry in vector \code{times}. If \code{cov} is \code{TRUE} then the \code{n x n} asymptotic
covariance matrix is estimated, where \code{n} is the length of vector \code{times}. If \code{left.limit} is \code{TRUE} then a left-continuous estimate of the survival function is calculated instead
of a right-continuous estimate (default). If a logical vector \code{rr.subset} is supplied, then only a subset of observations is used to estimate the response rates.
}
\references{
S.~Murray and A.~A. Tsiatis. Nonparametric survival estimation using prognostic longitudinal covariates. \emph{Biometrics}, 52(1):137--151, Mar. 1996.
}

