% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_models.R
\name{make_models}
\alias{make_models}
\title{Create models with different combinations of variables}
\usage{
make_models(vars, ncores = 2, k = NULL, verbose = TRUE)
}
\arguments{
\item{vars}{A character vector of variables to use for modeling}

\item{ncores}{An integer specifying the number of cores to use for parallel processing}

\item{k}{maximum number of variables in a model, default is NULL}

\item{verbose}{logical, defaults TRUE, sends messages about processing times}
}
\value{
A data frame containing all the possible linear permanova
models
}
\description{
Generates all possible linear models for a given set of
predictor variables using the distance matrix as a response variable.
The function allows for the user to specify the maximum number of
variables in a model, which can be useful in cases where there are
many predictors. The output is a data frame containing all the
possible models, which can be passed to the fit_models function for
fitting using a PERMANOVA approach.
}
\examples{
\donttest{
make_models(vars = c("A", "B", "C", "D"),
            ncores = 2, verbose = FALSE)

# using k as a way to limit number of variables
make_models(vars = c("A", "B", "C", "D"),
            ncores = 2, k = 2, verbose = FALSE)
}
}
\references{
Anderson, M. J. (2001). A new method for non-parametric multivariate analysis of variance. Austral Ecology, 26(1), 32-46.
}
