% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MR3d2.R
\name{spatial3dDouble}
\alias{spatial3dDouble}
\title{Spatial 3D Reasoning Item (double shapes)}
\usage{
spatial3dDouble(seed = 1, angle = pi/1.3, x = 0.3, y = 3, z = 0.8,
  cubes = 8, axis = TRUE, filled = "yes")
}
\arguments{
\item{seed}{To generate the same set of item(s) on the local computer.}

\item{angle, x, y, z}{See details}

\item{cubes}{The number of connected cubes together.}

\item{axis}{Showing the axis is helpful when first testing the function.}

\item{filled}{yes, no, random will determine the colour of the cubes. Ignore for now.}
}
\value{
\describe{
\item{figure}{Return the matrix that generates the display figure.}
\item{rotationMatrix}{Return the cordinates of x,y,z,w}
    }
}
\description{
This function generates a 3 dimensional display figure. It acts as a wrap because the creation of the figure is done using functions from the rgl package.
}
\details{
For 3D figures, some of the cubes may be hidden in sight when automatically generated. Hence, one would need to rotate the display figure several times to ensure that none of the cubes are hidden. To ensure that the same image is generated again, please provide a seed value. You will need to use the rgl post script function to save the figure. Currently, the function returns the a list object that is used to generate the display figure. The figure matrix in the list object can be used for the \code{\link{spatial3d_mirror}} to generate a mirror image of the display figure.

The arguments angle, x, y, z represents the rotation of angle radians based on the x, y and z axis. This is a wrapper to the rotationMatrix function from the rgl package. Changing the values in the arguments angle, x, y, z coordinates allows one to programmatically change angles to study potential cognitive operators at work.

You can also rotate the figure interactively by clicking on the figure and moving it in different direction.
}
\examples{
item <- spatial3dDouble(seed=4, angle=pi/1.3, x=0.3, y=4, z=0.8, cubes=9, axis = TRUE)

# To save the figure (not run)
# library(rgl)
# item <- spatial3dDouble(seed=4, angle=pi/1.3, x=0.3, y=4, z=0.8, cubes=9, axis = TRUE)

# save in pdf
# wd<- '~/desktop'
# item <- 1

# save <- paste0(wd,"/display3d_",item,".pdf")
# rgl.postscript(save,"pdf")

# save in png
# rgl.snapshot(filename="image3D.png",fmt="png")
}
\references{
\url{https://en.wikipedia.org/wiki/Radian}


Bejar, I. I. (1990). A generative analysis of a three-dimensional spatial task. \emph{Applied Psychological Measurement}, 14(3), 237-245.
}
\seealso{
\code{\link{lisy}}, \code{\link{arith}}, \code{\link{spatial2d}}, \code{\link{spatial3d_mirrorDouble}}
}
\author{
Aiden Loe and Francis Smart
}
