% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{show.aniso_simulation}
\alias{show.aniso_simulation}
\title{Show anisotropic simulation object}
\usage{
show.aniso_simulation(object)
}
\arguments{
\item{object}{an S4 object of class \code{aniso_simulation}}
}
\value{
Show a list of important parameters in class \code{aniso_simulation}.
}
\description{
Function to print the \code{aniso_simulation} class object after the
\code{aniso_simulation} model has been constructed.
}
\examples{
library(AIUQ)

# Simulate simple diffusion for 100 images with 100 by 100 pixels
aniso_sim_bm = aniso_simulation(sz=100,len_t=100,sigma_bm=c(0.5,0.1))
show(aniso_sim_bm)
}
\references{
Gu, M., He, Y., Liu, X., & Luo, Y. (2023). Ab initio uncertainty
quantification in scattering analysis of microscopy.
arXiv preprint arXiv:2309.02468.

Gu, M., Luo, Y., He, Y., Helgeson, M. E., & Valentine, M. T. (2021).
Uncertainty quantification and estimation in differential dynamic microscopy.
Physical Review E, 104(3), 034610.
}
\author{
\packageAuthor{AIUQ}
}
