% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{l2_estAB}
\alias{l2_estAB}
\title{Compute l2 loss for Dqt}
\usage{
l2_estAB(
  param,
  Dqt_cur,
  q_cur,
  d_input,
  model_name,
  msd_fn = NA,
  msd_grad_fn = NA
)
}
\arguments{
\item{param}{a vector of natural logarithm of parameters}

\item{Dqt_cur}{observed dynamic image structure function. See 'Details'.}

\item{q_cur}{wave vector in unit of um^-1}

\item{d_input}{sequence of lag times}

\item{model_name}{model name for the fitted model, options from ('BM','OU',
'FBM',OU+FBM','user_defined')}

\item{msd_fn}{msd_fn user defined mean squared displacement structure (MSD), a
function of \code{param} parameters and \code{d_input} lag times}

\item{msd_grad_fn}{user defined MSD gradient structure,  a function of
\code{param} and \code{d_input}}
}
\value{
Squared differences between the true Dqt and the predicted Dqt.
}
\description{
Compute l2 loss for dynamic image structure function(Dqt) using A(q) and B
are both estimated within the model.
}
\details{
Dynamic image structure function(Dqt) can be obtained from ensemble average
of absolute values squared of Four transformed intensity difference:
\deqn{D(q,\Delta t) = \langle |\Delta \hat{I}(q,t,\Delta t)|^2\rangle}{\%D(q,\Delta t) = \langle |\Delta \hat{I}(q,t,\Delta t)|^2\rangle}
See 'References'.
}
\references{
Gu, M., He, Y., Liu, X., & Luo, Y. (2023). Ab initio uncertainty
quantification in scattering analysis of microscopy.
arXiv preprint arXiv:2309.02468.

Gu, M., Luo, Y., He, Y., Helgeson, M. E., & Valentine, M. T. (2021).
Uncertainty quantification and estimation in differential dynamic microscopy.
Physical Review E, 104(3), 034610.

Cerbino, R., & Trappe, V. (2008). Differential dynamic microscopy: probing
wave vector dependent dynamics with a microscope. Physical review letters,
100(18), 188102.
}
\author{
\packageAuthor{AIUQ}
}
\keyword{internal}
