% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/occurrence_images.R
\name{occurrence_images}
\alias{occurrence_images}
\title{Find images using occurrence ids}
\usage{
occurrence_images(
  occ_id,
  fq,
  download = FALSE,
  download_path,
  sounds = FALSE,
  verbose = ala_config()$verbose
)
}
\arguments{
\item{occ_id}{character: IDs of occurrences as single sring or vector of
strings}

\item{fq}{string: (optional) character string or vector of strings,
specifying filters to be applied to the original query. These are of the
form "INDEXEDFIELD:VALUE" e.g. "kingdom:Fungi".}

\item{download}{logical: if TRUE download all images and add location to
dataframe}

\item{download_path}{string: (optional) filepath to download images to.
If not given and download param is TRUE, will create an images
folder}

\item{sounds}{logical (optional) Image search also returns sound files.
Ignored unless explicitly requested.}

\item{verbose}{logical: show additional progress information?
[default is set by ala_config()]}
}
\value{
Data frame of image results
}
\description{
Find images using occurrence ids
}
\examples{
\dontrun{
## Download all images for an occurrence with a CC BY-NC 4.0 licence
occurrence_image_search(id = "d201f3e0-3e1d-47f1-94ce-9fc226cbc5ec",
fq = "recognisedLicence:CC BY-NC 4.0",
download = TRUE)
}
}
\references{
\itemize{
\item Associated ALA web service for image search counts:
\url{https://images.ala.org.au/ws#/Search/search}
}
}
