% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AMAPVoxGenerics.R, R/AMAPVoxGetters.R
\docType{methods}
\name{getParameter}
\alias{getParameter}
\alias{getParameter,VoxHeader,character-method}
\alias{getParameter,VoxelSpace,character-method}
\title{Gets a parameter from the VoxelSpace header.}
\usage{
getParameter(object, what)

\S4method{getParameter}{VoxHeader,character}(object, what)

\S4method{getParameter}{VoxelSpace,character}(object, what)
}
\arguments{
\item{object}{either the \code{\link{VoxelSpace-class}} object or the
associated \code{\link{VoxHeader-class}}}

\item{what}{the name of the parameter}
}
\value{
the parameter as a \code{character}
}
\description{
Gets a parameter from the VoxelSpace header.
}
\examples{
# load a voxel file
vox <- readVoxelSpace(system.file("extdata", "als_sample.vox", package = "AMAPVox"))
# retrieve 'min_corner' parameter
getParameter(vox, "min_corner")
}
\seealso{
\code{\link{VoxHeader-class}}, \code{\link{VoxelSpace-class}};
}
