% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ground.R
\docType{methods}
\name{ground}
\alias{ground}
\alias{belowGround}
\alias{aboveGround}
\alias{groundEnergy}
\alias{groundElevation}
\title{Extract ground from voxel space.}
\usage{
ground(vxsp)

belowGround(vxsp)

aboveGround(vxsp)

groundEnergy(vxsp)

groundElevation(vxsp)
}
\arguments{
\item{vxsp}{a \code{\link{VoxelSpace-class}} object.}
}
\value{
\link[data.table:data.table-class]{data.table::data.table} object with voxel index either
below ground, ground level or above ground.
}
\description{
Extract ground layer from \code{\link{VoxelSpace-class}} object.
\subsection{Ground layer}{

The ground layer is the set of voxels that are just above ground level. The
bottom facet of the voxel must be above ground
\code{ground_distance(voxel_center) >= dz/2} with dz the voxel size on z axis.
Ground layer may be missing (the function returns an empty data.table) or
incomplete (the function returns a data.table with
\code{nrow(ground(vxsp)) < prod(dim(vxsp)[1:2])}) for some voxel space.
}

\subsection{Above/below ground}{

Function \code{aboveGround} returns voxel index above ground layer (included).
Function \code{belowGround} returns voxel index below ground layer (excluded).
}

\subsection{Ground energy}{

Function \code{groundEnergy} estimates fraction of light reaching the ground. It
is computed as the ratio of entering beam section on potential beam section
(beams that would have crossed a voxel if there were no vegetation in the
scene). It requires variables \emph{bsEntering} and \emph{bsPotential}.
}

\subsection{Ground elevation}{

Function \code{groundElevation} returns the elevation of the ground layer. It is
provided as a check function, to make sure that AMAPVox
\emph{digital elevation model} is consistent with the one provided in input.
}
}
\examples{
vxsp <- readVoxelSpace(system.file("extdata", "tls_sample.vox", package = "AMAPVox"))
gr <- ground(vxsp)
ag <- aboveGround(vxsp)
bg <- belowGround(vxsp) # empty in test case
# ground layer included in above ground subset
all(ag[gr, on=list(i, j, k)] == gr) # TRUE expected
vxsp@data[ag, on=list(i, j, k)]

}
