% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Operators.R
\name{Extract}
\alias{Extract}
\alias{$,VoxelSpace-method}
\alias{[[,VoxelSpace,ANY,missing-method}
\alias{$<-,VoxelSpace-method}
\alias{[[<-,VoxelSpace,ANY,missing-method}
\title{Extract or Replace Parts of a VoxelSpace Object}
\usage{
\S4method{$}{VoxelSpace}(x, name)

\S4method{[[}{VoxelSpace,ANY,missing}(x, i, j, ...)

\S4method{$}{VoxelSpace}(x, name) <- value

\S4method{[[}{VoxelSpace,ANY,missing}(x, i, j) <- value

\S4method{$}{VoxelSpace}(x, name) <- value
}
\arguments{
\item{x}{a \code{\linkS4class{VoxelSpace}} object}

\item{name}{A literal character string or a name (possibly backtick quoted).}

\item{i}{string, name of elements to extract.}

\item{j}{Unused.}

\item{\dots}{Unused.}

\item{value}{typically an array-like R object of a similar class as x.}
}
\description{
Operators acting on \code{\linkS4class{VoxelSpace}} object. If user attempts
}
\examples{
# load a voxel file
vxsp <- readVoxelSpace(system.file("extdata", "tls_sample.vox", package = "AMAPVox"))

# extract columns or header parameters
vxsp$nbSampling
vxsp[["i"]]
vxsp[["mincorner"]]

\dontrun{
# add new column
vxsp[["pad_capped"]] <- ifelse(vxsp$PadBVTotal > 0.5, 0.5, vxsp$PadBVTotal)
# update header parameter
vxsp[["max_pad"]] <- 0.5
}

}
