% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{Front page plots}
\alias{Front page plots}
\alias{plot_hcr}
\alias{plot_biomass}
\alias{plot_catch}
\alias{plot_projection}
\alias{plot_hcr_intro_arrow}
\alias{plot_metric_with_histo}
\alias{plot_kobe_majuro_projections}
\alias{plot_yieldcurve_projections}
\title{Plots for the front page of the Introduction to HCRs and other AMPED apps.}
\usage{
plot_hcr(stock, stock_params, mp_params, app_params, timestep = NULL,
  show_last = TRUE)

plot_biomass(stock, stock_params, mp_params, timestep = NULL,
  show_last = TRUE, max_spaghetti_iters = 50, quantiles,
  nspaghetti = 5, add_grid = TRUE, xlab = "Year",
  ghost_col = "grey", last_col = "blue", ylim = c(0, 1), ...)

plot_catch(stock, stock_params, mp_params, app_params = NULL,
  timestep = NULL, show_last = TRUE, max_spaghetti_iters = 50,
  quantiles, nspaghetti = 5, add_grid = TRUE, xlab = "Year",
  ghost_col = "grey", true_col = "black", ...)

plot_projection(stock, stock_params, mp_params, app_params = NULL,
  show_last = TRUE, max_spaghetti_iters = 50, quantiles,
  nspaghetti = 5, add_grid = TRUE, ...)

plot_hcr_intro_arrow(stock, timestep)

plot_metric_with_histo(stock, stock_params, mp_params, metric,
  app_params = NULL, show_last = TRUE, quantiles = c(0.2, 0.8))

plot_kobe_majuro_projections(stock, stock_params, choice = "kobe")

plot_yieldcurve_projections(stock, stock_params, app_params)
}
\arguments{
\item{stock}{A list with elements biomass, hcr_ip, hcr_op, effort and catch.}

\item{stock_params}{A vector of life history and stochasticy parameters.}

\item{mp_params}{A vector of management procedure parameters.}

\item{app_params}{A vector of application parameters.}

\item{timestep}{The current timestep (optional).}

\item{show_last}{Show the previous iters as ghosts (optional).}

\item{max_spaghetti_iters}{The number of iterations to show as spaghetti before ribbons are shown.}

\item{quantiles}{Quantiles of the ribbons.}

\item{nspaghetti}{The number of spaghetti iterations to plot on top of the ribbons.}

\item{add_grid}{Add a grid.}

\item{xlab}{The x-label.}

\item{ghost_col}{Colours of the ghost iterations.}

\item{last_col}{Colours of the last iteration.}

\item{ylim}{Y limits}

\item{...}{Other arguments to pass to the plot() function.}

\item{true_col}{Colour of the current iteration.}

\item{metric}{The name of the metric to plot (catch, biomass or relcpue).}

\item{choice}{Either kobe or majuro.}
}
\value{
A plot

A plot

A plot

A plot

A plot

A plot

A plot

A plot
}
\description{
plot_hcr() plots the shape of the HCR.

plot_biomass() plots time series of 'true' and observed depletion (SB/SBF=0).

plot_catch() plots time series of catches.

plot_projection() plots time series of depletion, catch and relative effort for the Introduction to Projections app.

plot_hcr_intro_arrow() draws an arrow between the depletion plot and the HCR plot for the Introduction to HCRs app.

plot_metric_with_histo() is the generic plotting routine for plotting time series of metrics with histograms of the final time step.

plot_kobe_majuro_projections() plots a Kobe or Majuro plot for the Introduction to Projections app.

plot_yieldcurve_projections() plots a yield curve (catch against effort) for the Introduction to Projections app.
}
\examples{
# Set up all the bits for a projection - should be done inside a Shiny app
# Managment procedure bits - should come from Shiny app inputs
input_mp <- list(
  blim_belbow = c(0.2, 0.5),
  cmin_cmax = c(10, 140), 
  constant_catch_level = 50,
  constant_effort_level = 1,
  emin_emax = c(0.1, 0.5),
  hcr_type = "threshold_catch")
mp_params <- mp_params_switcheroo(input_mp)

# Stochasticity bits - should come from Shiny app inputs
input_stoch <- list(
  biol_est_bias = 0,
  biol_est_sigma = 0.2,
  biol_prod_sigma = 0.2, 
  show_var <- TRUE)
stoch_params <- set_stoch_params(input_stoch)

# Life history bits - should come from Shiny app inputs
input_lh <- list(
  stock_history = "fully",
  stock_lh = "medium")
lh_params <- get_lh_params(input_lh)

# Stitch together and make other parameters - should be inside an Shiny app 
stock_params <- c(stoch_params, lh_params)
app_params <- list(initial_year = 2009, last_historical_timestep = 10)

# Make the null stock and fill it up
# In a Shiny app use the create_stock() function but cannot do here so make an equivalent object
stock <- list(biomass = NULL, hcr_ip = NULL, hcr_op = NULL, effort = NULL, catch = NULL)
stock <- reset_stock(stock = stock, stock_params = stock_params, mp_params = mp_params,
  app_params = app_params, initial_biomass = stock_params$b0, nyears = 20, niters = 100)
# Finally project over the timesteps
stock <- project(stock, timesteps = c(11,20), stock_params = stock_params,
  mp_params = mp_params, app_params = app_params)

# The plots
# Plot the HCR
plot_hcr(stock=stock, stock_params=stock_params, mp_params=mp_params, app_params=app_params)
# Plot biomass timeseries
plot_biomass(stock=stock, stock_params=stock_params, mp_params=mp_params, quantiles=c(0.2,0.8))
# Plot catch timeseries
plot_catch(stock=stock, stock_params=stock_params, mp_params=mp_params, quantiles=c(0.2,0.8))
# Plot the projection (biomass, catch and rel cpue)
plot_projection(stock=stock, stock_params=stock_params, mp_params=mp_params,
  app_params=app_params, quantiles=c(0.2,0.8))
# The arrow connecting the HCR to the biomass
plot_hcr_intro_arrow(stock=stock, timestep=15)
# Time series with a histogram on the end
plot_metric_with_histo(stock=stock, stock_params=stock_params, mp_params=mp_params,
  metric="catch", app_params=app_params)
# Kobe or Majuro plot
# Just a few iters for efficiency
stock2 <- lapply(stock, '[',1:5,)
plot_kobe_majuro_projections(stock=stock2, stock_params=stock_params, choice="kobe")
# Yield curve
plot_yieldcurve_projections(stock=stock2, stock_params=stock_params, app_params=app_params)
}
