% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funcs.R
\name{project}
\alias{project}
\alias{get_hcr_op}
\title{Projects the stock over the timesteps given and updates the biomass, HCR ip / op and catches}
\usage{
project(stock, timesteps, stock_params, mp_params, app_params,
  max_releffort = 10)

get_hcr_op(stock, stock_params, mp_params, yr)
}
\arguments{
\item{stock}{A list with elements biomass, hcr_ip, hcr_op, effort and catch.}

\item{timesteps}{The timesteps to project over. A vector of length 2 (start and end).}

\item{stock_params}{A vector of life history and stochasticy parameters.}

\item{mp_params}{A vector of management procedure parameters.}

\item{app_params}{A vector of application parameters.}

\item{max_releffort}{The maximum relative effort.}

\item{yr}{Evaluate the HCR in a particular year (timestep).}
}
\value{
A stock object (a reactiveValues object with bits for the stock)

A vector of outputs from the HCR.
}
\description{
project() uses a simple biomass dynamic model where the catches or fishing effort are set every timestep by the harvest control rule.

get_hcr_op() evaluates the harvest control rule in a single year (timestep) for multiple iterations.
}
\examples{
# Set up all the bits for a projection - should be done inside a Shiny app
# Managment procedure bits - should come from Shiny app inputs
input_mp <- list(
  blim_belbow = c(0.2, 0.5),
  cmin_cmax = c(10, 140), 
  constant_catch_level = 50,
  constant_effort_level = 1,
  emin_emax = c(0.1, 0.5),
  hcr_type = "threshold_catch")
mp_params <- mp_params_switcheroo(input_mp)

# Stochasticity bits - should come from Shiny app inputs
input_stoch <- list(
  biol_est_bias = 0,
  biol_est_sigma = 0,
  biol_prod_sigma = 0, 
  show_var <- TRUE)
stoch_params <- set_stoch_params(input_stoch)

# Life history bits - should come from Shiny app inputs
input_lh <- list(
  stock_history = "fully",
  stock_lh = "medium")
lh_params <- get_lh_params(input_lh)

# Stitch together and make other parameters - should be inside an Shiny app 
stock_params <- c(stoch_params, lh_params)
app_params <- list(initial_year = 2009, last_historical_timestep = 10)

# Make the null stock and fill it up
# In a Shiny app use the create_stock() function but cannot do here so make an equivalent object
stock <- list(biomass = NULL, hcr_ip = NULL, hcr_op = NULL, effort = NULL, catch = NULL)
stock <- reset_stock(stock = stock, stock_params = stock_params, mp_params = mp_params,
  app_params = app_params, initial_biomass = stock_params$b0, nyears = 20, niters = 10)

# Finally project over the timesteps
out <- project(stock, timesteps = c(11,20), stock_params = stock_params, mp_params = mp_params,
  app_params = app_params)

# Or just get the HCR op in a single timestep
hcr_op <- get_hcr_op(stock=stock, stock_params=stock_params, mp_params=mp_params, yr=10)
}
