% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clipboard.R
\name{clipboard}
\alias{clipboard}
\alias{clipboard_import}
\alias{clipboard_export}
\title{Import/export from clipboard}
\usage{
clipboard_import(sep = "\\t", quote = "", header = TRUE, dec = ".",
  na = c("", "NA", "NULL"), stringsAsFactors = FALSE, startrow = 1,
  as_vector = TRUE, guess_col_types = TRUE, date_names = "en",
  date_format = "\%Y-\%m-\%d", time_format = "\%H:\%M",
  remove_ASCII_escape_char = FALSE, tz = "UTC", encoding = "UTF-8",
  info = TRUE)

clipboard_export(x, sep = "\\t", dec = ".", na = "", header = TRUE,
  info = TRUE)
}
\arguments{
\item{sep}{the field separator character.  Values on each line of the
    file are separated by this character.  If \code{sep = ""} (the
    default for \code{read.table}) the separator is \sQuote{white space},
    that is one or more spaces, tabs, newlines or carriage returns.}

\item{quote}{the set of quoting characters. To disable quoting
    altogether, use \code{quote = ""}.  See \code{\link{scan}} for the
    behaviour on quotes embedded in quotes.  Quoting is only considered
    for columns read as character, which is all of them unless
    \code{colClasses} is specified.}

\item{header}{a logical value indicating whether the file contains the
    names of the variables as its first line.  If missing, the value is
    determined from the file format: \code{header} is set to \code{TRUE}
    if and only if the first row contains one fewer field than the
    number of columns.}

\item{dec}{the character used in the file for decimal points.}

\item{na}{the string to use for missing values in the data.}

\item{stringsAsFactors}{logical: should character vectors be converted
    to factors?  The \sQuote{factory-fresh} default is \code{TRUE}, but
    this can be changed by setting \code{\link{options}(stringsAsFactors
      = FALSE)}.}

\item{startrow}{\emph{n}th row to start importing from. When \code{header = TRUE}, the import will start on row \code{startrow} \emph{below} the header.}

\item{as_vector}{a logical value indicating whether data consisting of only one column should be imported as vector using \code{\link[dplyr]{pull}}. This will strip off the header.}

\item{guess_col_types}{a logical value indicating whether column types should be guessed and transformed automatically with \code{\link[readr]{parse_guess}} from the \code{readr} package. Besides, the antimicrobial classes in this AMR package (\code{\link{as.rsi}} and \code{\link{as.mic}}) are also supported.}

\item{date_names}{Character representations of day and month names. Either
the language code as string (passed on to \code{\link[=date_names_lang]{date_names_lang()}})
or an object created by \code{\link[=date_names]{date_names()}}.}

\item{date_format}{Default date and time formats.}

\item{time_format}{Default date and time formats.}

\item{remove_ASCII_escape_char}{remove ASCII escape character}

\item{tz}{Default tz. This is used both for input (if the time zone isn't
present in individual strings), and for output (to control the default
display). The default is to use "UTC", a time zone that does not use
daylight savings time (DST) and hence is typically most useful for data.
The absence of time zones makes it approximately 50x faster to generate
UTC times than any other time zone.

Use \code{""} to use the system default time zone, but beware that this
will not be reproducible across systems.

For a complete list of possible time zones, see \code{\link{OlsonNames}()}.
Americans, note that "EST" is a Canadian time zone that does not have
DST. It is \emph{not} Eastern Standard Time. It's better to use
"US/Eastern", "US/Central" etc.}

\item{encoding}{encoding to be assumed for input strings.  It is
    used to mark character strings as known to be in
    Latin-1 or UTF-8 (see \code{\link{Encoding}}): it is not used to
    re-encode the input, but allows \R to handle encoded strings in
    their native encoding (if one of those two).  See \sQuote{Value}
    and \sQuote{Note}.
  }

\item{info}{print info to console}

\item{x}{the object to be written, preferably a matrix or data frame.
    If not, it is attempted to coerce \code{x} to a data frame.}
}
\description{
These are helper functions around \code{\link{read.table}} and \code{\link{write.table}} to import from and export to clipboard with support for Windows, Linux and macOS.

The data will be read and written as tab-separated by default, which makes it possible to copy and paste from other software like Excel and SPSS without further transformation.

This also supports automatic column type transformation, with AMR classes \code{\link{as.rsi}} and \code{\link{as.mic}}.
}
\details{
The parameter \code{stringsAsFactors} defaults to \code{FALSE}, as opposed to most base \R methods.

The parameters \code{date_format} and \code{time_format} also support generic date and time formats like \code{"dd-mm-yyyy"} like Excel.

  \if{html}{
    \strong{Example for copying from Excel:}
    \out{<div style="text-align: left">}\figure{clipboard_copy.png}\out{</div>}
    \cr
    \strong{And pasting in R:} \cr
    \cr
    \code{> data <- clipboard_import()} \cr
    \code{> data} \cr
    \out{<div style="text-align: left">}\figure{clipboard_paste.png}\out{</div>}
    \cr
    \strong{The resulting data contains the right RSI-classes:} \cr
    \cr
    \code{> data$amox} \cr
    \out{<div style="text-align: left">}\figure{clipboard_rsi.png}\out{</div>}
  }
}
\examples{
\dontrun{

df1 <- data.frame(a = letters[1:12],
                  b = runif(n = 12, min = 1000, max = 2000),
                  stringsAsFactors = FALSE)
clipboard_export(df1)
df2 <- clipboard_import()
identical(df1, df2)

# send frequency table to clipboard (e.g. for pasting in Excel)
septic_patients \%>\%
  freq(age) \%>\%
  format() \%>\%       # this will format the percentages
  clipboard_export()
}
}
\keyword{clipboard}
\keyword{clipboard_export}
\keyword{clipboard_import}
\keyword{export}
\keyword{import}
