% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n_rsi.R
\name{n_rsi}
\alias{n_rsi}
\title{Count cases with antimicrobial results}
\usage{
n_rsi(ab1, ab2 = NULL)
}
\arguments{
\item{ab1, ab2}{vector of antibiotic interpretations, they will be transformed internally with \code{\link{as.rsi}} if needed}
}
\description{
This counts all cases where antimicrobial interpretations are available. Its use is equal to \code{\link{n_distinct}}.
}
\examples{
library(dplyr)

septic_patients \%>\%
  group_by(hospital_id) \%>\%
  summarise(cipro_p = portion_S(cipr, as_percent = TRUE),
            cipro_n = n_rsi(cipr),
            genta_p = portion_S(gent, as_percent = TRUE),
            genta_n = n_rsi(gent),
            combination_p = portion_S(cipr, gent, as_percent = TRUE),
            combination_n = n_rsi(cipr, gent))
}
\seealso{
The \code{\link{portion}} functions to calculate resistance and susceptibility.
}
