% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mic.R
\name{as.mic}
\alias{as.mic}
\alias{mic}
\alias{is.mic}
\title{Class 'mic'}
\usage{
as.mic(x, na.rm = FALSE)

is.mic(x)
}
\arguments{
\item{x}{vector}

\item{na.rm}{a logical indicating whether missing values should be removed}
}
\value{
Ordered \code{\link{factor}} with new class \code{\link{mic}}
}
\description{
This transforms a vector to a new class \code{\link{mic}}, which is an ordered \code{\link{factor}} with valid MIC values as levels. Invalid MIC values will be translated as \code{NA} with a warning.
}
\details{
To interpret MIC values as RSI values, use \code{\link[=as.rsi]{as.rsi()}} on MIC values. It supports guidelines from EUCAST and CLSI.
}
\section{Read more on our website!}{

On our website \url{https://msberends.gitlab.io/AMR} you can find \href{https://msberends.gitlab.io/AMR/articles/AMR.html}{a tutorial} about how to conduct AMR analysis, the \href{https://msberends.gitlab.io/AMR/reference}{complete documentation of all functions} (which reads a lot easier than here in R) and \href{https://msberends.gitlab.io/AMR/articles/WHONET.html}{an example analysis using WHONET data}.
}

\examples{
mic_data <- as.mic(c(">=32", "1.0", "1", "1.00", 8, "<=0.128", "8", "16", "16"))
is.mic(mic_data)

# this can also coerce combined MIC/RSI values:
as.mic("<=0.002; S") # will return <=0.002

# interpret MIC values
as.rsi(x = as.mic(2),
       mo = as.mo("S. pneumoniae"),
       ab = "AMX",
       guideline = "EUCAST")
as.rsi(x = as.mic(4),
       mo = as.mo("S. pneumoniae"),
       ab = "AMX",
       guideline = "EUCAST")

plot(mic_data)
barplot(mic_data)
freq(mic_data)
}
\seealso{
\code{\link[=as.rsi]{as.rsi()}}
}
