% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/met.disparity.R
\name{met.disparity}
\alias{met.disparity}
\title{Disparity}
\usage{
met.disparity(M, df = NULL, dfid = NULL)
}
\arguments{
\item{M}{a square adjacency matrix, or a list of square adjacency matrices, or an output of ANT functions \emph{stat.ds.grp}, \emph{stat.df.focal}, \emph{stat.net.lk}.}

\item{df}{a data frame of same length as the input matrix or a list of data frames if argument \emph{M} is a list of matrices or an output of ANT functions \emph{stat.ds.grp}, \emph{stat.df.focal}, \emph{stat.net.lk}.}

\item{dfid}{an integer or a string indicating the column with individual ids in argument \emph{df}.}
}
\value{
\itemize{
\item An integer vector of nodes \emph{disparity} if argument \emph{df} is \emph{NULL}.
\item A list of integer vectors of nodes \emph{disparity} if argument \emph{M} is a list of matrices and if argument \emph{df} is \emph{NULL}.
\item A list of arguments df with a new column for nodes \emph{disparity} titled 'disparity', if argument \emph{df} is not \emph{NULL}.
\item A list of arguments df with a new column for nodes \emph{disparity} if 1) argument \emph{df} is not \emph{NULL}, 2) argument \emph{M} is an output from ANT functions \emph{stat.ds.grp}, \emph{stat.df.focal}, \emph{stat.net.lk} for multiple matrices permutations, and 3) argument \emph{df} is a list of data frames of same length as argument \emph{M}. The name of the column of each element of the list is adapted according to argument value \emph{binary}.
}
}
\description{
Calculates the node metric disparity for all vertices.
}
\details{
Disparity measures the variation of the weight of a node. This metric compares a node's strength with its degree. It informs on the type of edges a node \emph{i} has, \emph{i.e.} few strong edges or many weak edges.
Disparity of a vertex \emph{i} is the sum of the squares of the division between the weigthed edge between node \emph{i} and \emph{j} and the met.strength of node \emph{i}
}
\examples{
met.disparity(sim.m)
head(sim.df)
met.disparity(sim.m,df=sim.df)
}
\references{
Barthelemy, M., Barrat, A., Pastor-Satorras, R., & Vespignani, A. (2005). Characterization and modeling of weighted networks. Physica a: Statistical mechanics and its applications, 346(1-2), 34-43.

Whitehead, H. (2009). SOCPROG programs: analysing animal social structures. Behavioral Ecology and Sociobiology, 63(5), 765-778.

Sosa, S. (2018). Social Network Analysis, \emph{in}: Encyclopedia of Animal Cognition and Behavior. Springer.
}
\author{
Sebastian Sosa, Ivan Puga-Gonzalez.
}
