% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat.deletions.R
\name{stat.deletions}
\alias{stat.deletions}
\title{Network target & random deletion simulations}
\usage{
stat.deletions(
  M,
  attr,
  target,
  ndel,
  nsim,
  weighted = TRUE,
  shortest.weight = FALSE,
  normalization = FALSE,
  directed = TRUE,
  out = TRUE,
  progress = TRUE,
  return.mat = FALSE
)
}
\arguments{
\item{M}{a square adjacency M.}

\item{attr}{a vector of categorical (factor or character) or numeric (continuous) attributes of the nodes. The vector must have the same length and order as the nodes in the square adjacency matrix 'M'.}

\item{target}{Indicates the nodes that will be the target of deletion. If the argument 'attr' is categorical, then 'target' indicates the attribute of the node target of deletion. If the argument 'attr' is numeric,
then 'target' can take one of two character elements 1) 'decreasing' or 2) 'increasing' indicating whether the target of deletions are nodes with the greatest or lowest attribute's values respectively.}

\item{ndel}{an integer indicating the number of deletions to perform in each simulation.}

\item{nsim}{an integer indicating the number of simulations, \emph{i.e.} how many times to perform \emph{ndel} deletions.}

\item{weighted}{if \emph{true}, it binarizes the square adjacency matrix M. Geodesic distances and diameter are based only on the presence or absence of edges.}

\item{shortest.weight}{if \emph{false}, it considers the higher met.strength as the shortest path.}

\item{normalization}{normalizes the weights of the links i.e. divides them by the average strength of the network. Argument normalization can't be TRUE when argument weighted is FALSE.}

\item{directed}{if \emph{false}, then it symmetrizes the matrix. Otherwise, it calculates geodesic distances and diameter according to the directionality of the links.}

\item{out}{if \emph{true}, it considers outgoing ties for the diameter and the geodesic distances.}

\item{progress}{a boolean if \emph{TRUE} it prints the progress of the simulations.}

\item{return.mat}{a boolean if \emph{TRUE} it returns a list of two elements : 1) a list of matrix deletions through target deletion; 2) a list of matrix deletions through random deletion}
}
\value{
A list of two elements:
\itemize{
\item The first element is the diameter of the network according to the option specified (weighted or not, directed or not, through lowest weights or greatest weights)
\item The second element is the geodesic distances between all nodes according to the option specified (weighted or not, directed or not, through lowest weights or greatest weights)
}
}
\description{
Perfoms a knockout analysis according to specific vertex attributes and a specific percentage of nodes to delete
}
\details{
Knockout analysis allows the study of resilience properties of networks when specific nodes are removed. It is usually compared with random deletions.
}
\examples{
# Simulating data
m <- matrix(sample(c(0:5), 50 * 50, TRUE), 50, 50)
diag(m) <- 0
mb <- mat.binaryzation(m)

# Weighted categorical attribute example
attr <- sample(c("a", "b"), 50, TRUE)
t <- stat.deletions(m, attr = attr, target = "a", nsim = 2, ndel = 10)
t <- stat.deletions(mb, attr = attr, target = "a", nsim = 2, ndel = 10)
#  continous attribute example
attr <- c(sample(c(1:10), 50, TRUE))

t <- stat.deletions(m, attr = attr, target = "decreasing", nsim = 2, ndel = 4)
t <- stat.deletions(mb, attr = attr, target = "decreasing", nsim = 2, ndel = 4)
}
\references{
Lusseau D. 2003. The emergent properties of a dolphin social network. Proceedings of the Royal Society of London Series B: Biological Sciences 270(Suppl 2):S186-S188.

Manno TG. 2008. Social networking in the Columbian ground squirrel, Spermophilus columbianus. Animal Behaviour 75(4):1221-1228.

Kanngiesser P, Sueur C, Riedl K, Grossmann J, Call J. 2011. Grooming network cohesion and the role of individuals in a captive chimpanzee group. American journal of primatology 73(8):758-767.

Sosa S. 2014. Structural Architecture of the Social Network of a Non-Human Primate (Macaca sylvanus): A Study of Its Topology in La Foret des Singes, Rocamadour. Folia Primatologica 85(3):154-163.

Sosa, S. (2018). Social Network Analysis, \emph{in}: Encyclopedia of Animal Cognition and Behavior. Springer.
}
\author{
Sebastian Sosa, Ivan Puga-Gonzalez.
}
