% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_density.R
\name{plot_density}
\alias{plot_density}
\title{Plot the density of one metric or categorical variable}
\usage{
plot_density(
  dat,
  y_var,
  plot_type = "density",
  apc_range = NULL,
  highlight_diagonals = NULL,
  y_var_cat_breaks = NULL,
  y_var_cat_labels = NULL,
  weights_var = NULL,
  log_scale = FALSE,
  xlab = NULL,
  ylab = NULL,
  legend_title = NULL,
  ...
)
}
\arguments{
\item{dat}{Dataset with columns \code{period} and \code{age} and the
main variable specified through argument \code{y_var}.}

\item{y_var}{Character name of the main variable to be plotted.}

\item{plot_type}{One of \code{c("density","boxplot")}. Only used if the
\code{y_var} column is metric.}

\item{apc_range}{Optional list with one or multiple elements with names
\code{"age","period","cohort"} to filter the data. Each element should
contain a numeric vector of values for the respective variable that should
be kept in the data. All other values are deleted.}

\item{highlight_diagonals}{Optional internal parameter which is only
specified when \code{plot_density} is called from within
\code{plot_densityMatrix}. See \code{\link{plot_densityMatrix}} for details.}

\item{y_var_cat_breaks}{Optional numeric vector of breaks to categorize
\code{y_var} based on calling function \code{\link{cut}}. Only used to
highlight the categories based on different colors. And only used if the
\code{y_var} column is numeric.}

\item{y_var_cat_labels}{Optional character vector for the names of the
categories that were defined based on \code{y_var_cat_breaks}. The length of
this vector must be one shorter than \code{length(y_var_cat_breaks)}. Only
used if the \code{y_var} column is numeric.}

\item{weights_var}{Optional character name of a weights variable used to
project the results in the sample to some population.}

\item{log_scale}{Indicator if the main variable should be log10 transformed.
Only used if the \code{y_var} column is numeric. Defaults to FALSE.}

\item{xlab, ylab, legend_title}{Optional plot annotations.}

\item{...}{Additional arguments passed to \code{\link[stats]{density}}.}
}
\value{
ggplot object
}
\description{
Create a density plot or a boxplot of one metric variable or a barplot
of one categorical variable, based on a specific subset of the data.
}
\details{
If \code{plot_density} is called internally from within
\code{\link{plot_densityMatrix}} (i.e., if the dataset contains some of the
columns \code{c("age_group","period_group","cohort_group")}), this function
will calculate the metric densities individually for these groups.
}
\examples{
library(APCtools)
data(travel)

plot_density(dat = travel, y_var = "mainTrip_distance")

plot_density(dat = travel, y_var = "mainTrip_distance")

}
\author{
Alexander Bauer \email{alexander.bauer@stat.uni-muenchen.de},
Maximilian Weigert \email{maximilian.weigert@stat.uni-muenchen.de}
}
