% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/APIS_functions.R
\name{APIS}
\alias{APIS}
\title{APIS function that assigns with observed data}
\usage{
APIS(off.genotype, sire.genotype, dam.genotype, error = 0,
  exclusion.threshold = ncol(off.genotype), preselect.Parent = FALSE,
  nb.cores = 2, verbose = TRUE)
}
\arguments{
\item{off.genotype}{Offspring genotypes | Matrix (n*p)
where n = number of individuals
p = number of markers
rownames(offspring) = labels of offspring
marker coding = "All1/All2" example: "A/A", "A/B", "NA/NA" (for missing genotype)}

\item{sire.genotype}{Sire genotypes | Matrix (n*p)
where n = number of individuals
p = number of markers
rownames(sire) = labels of sires
marker coding = "All1/All2" example: "A/A", "A/B", "NA/NA" (for missing genotype)}

\item{dam.genotype}{Dam genotypes | Matrix (n*p)
where n = number of individuals
p = number of markers
rownames(dam) = labels of dams
marker coding = "All1/All2" example: "A/A", "A/B", "NA/NA" (for missing genotype)}

\item{error}{(default: 0) The assignment error rate accepted by the user}

\item{exclusion.threshold}{(default: ncol(off.genotype)) Threshold for exclusion (number of mismatches allowed)}

\item{preselect.Parent}{(default: FALSE) Preselection of parents. Can be FALSE, an integer or a vector of two integers (number of sires, numbers of dams)}

\item{nb.cores}{(default: 2) Number of cores to use. If you have more than 2 cores, you can use the "parallel" function detectCores()}

\item{verbose}{(default : TRUE) Display the process of the function on the console.}
}
\value{
pedigree

a log file
}
\description{
This function performs the APIS procedure
}
\examples{
data("APIS_offspring")
data("APIS_sire")
data("APIS_dam")

result <- APIS(off.genotype = APIS_offspring[1:50, ],
               sire.genotype = APIS_sire,
               dam.genotype = APIS_dam,
               error = 0.05,
               verbose = FALSE)

}
\keyword{APIS}
\keyword{assignment}
