% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integration.R
\name{integrate_tcr}
\alias{integrate_tcr}
\title{Integrate a TCR library into Seurat object metadata}
\usage{
integrate_tcr(seurat_obj, tcr_file, verbose = TRUE)
}
\arguments{
\item{seurat_obj}{Seurat object}

\item{tcr_file}{`data.frame` of the T cell library generated by Cell Ranger. It is very important that the row with cell barcodes is strictly named `"barcode"`, which is the default name of barcodes in 10X's `all_contig_annotations.csv` file.}

\item{verbose}{if `TRUE`, will display a progress bar to the R console.}
}
\value{
Returns a new Seurat object with new elements in the metadata
}
\description{
Modifies a `Seurat` object's metadata by taking all the columns
of the `all_contig_annotations.csv`, and adding new elements to `seurat_obj@meta.data`, 
corresponding to each cells' barcodes and handling duplicates (since the sequencing
of TRA and TRB genes creates multiple data points for the same cell).
}
\details{
Columns from cells (barcodes) that had duplicates in another row are
concatenated into strings, separated by `__` in the metadata element. Barcodes
from the TCR library that had no matches to barcodes in the `seurat_obj` will
add `NA`s for all elements of the same index.
}
\examples{
library(Seurat)
library(APackOfTheClones)
data("mini_clonotype_data","mini_seurat_obj")

# integrate the TCR data into new seurat object
integrated_seurat_object <- integrate_tcr(mini_seurat_obj, mini_clonotype_data)
integrated_seurat_object

}
\references{
atakanekiz (2019) Tutorial:Integrating VDJ sequencing data with Seurat. `https://www.biostars.org/p/384640/`
}
\concept{sc_RNAseq}
