% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crit_val_bounds_sim.R
\name{f_bounds_sim}
\alias{f_bounds_sim}
\title{Critical value bounds stochastic simulation for Wald bounds-test for no
cointegration}
\usage{
f_bounds_sim(case, k, alpha, T, R = 40000)
}
\arguments{
\item{case}{An integer from 1-5 specifying whether the 'intercept' and/or the
trend' have to participate in the long-run/cointegrating
relationship/equation (see section 'Cases' in \code{\link{bounds_f_test}}).}

\item{k}{The number of independent variables.}

\item{alpha}{A numeric vector between 0 and 1 indicating the significance
level of the critical value bounds. Multiple values can be used.}

\item{T}{An integer indicating the number of observations.}

\item{R}{An integer indicating how many iterations will be used. Default is
40000.}
}
\value{
\code{f_bounds_sim} returns a list containing two data frames. One
  with the critical value bounds for the F-statistic and one with the
  critical value bounds for the Chisq-statistic.
}
\description{
\code{f_bounds_sim} simulates the critical value bounds for the  Wald
bounds-test for no cointegration \cite{Pesaran et al. (2001)} expressed both
as F-statistics and as Chisq-statistics.
}
\seealso{
\code{\link{t_bounds_sim}} \code{\link{bounds_f_test}}
}
\author{
Kleanthis Natsiopoulos, \email{klnatsio@gmail.com}
}
\keyword{internal}
\keyword{ts}
