% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argos_files.R
\name{linear3d_system}
\alias{linear3d_system}
\title{Linear 3D System}
\usage{
linear3d_system(n, init_conditions, dt, snr = Inf)
}
\arguments{
\item{n}{Number of time points (rounded to the nearest integer).}

\item{init_conditions}{Initial conditions as a numeric vector of length 3.}

\item{dt}{Time step between observations.}

\item{snr}{Signal-to-noise ratio (in dB). Use Inf for no noise.}
}
\value{
A numeric matrix representing the system's state over time. Each row
        corresponds to a time point, and each column represents a variable.
}
\description{
Simulates a three-dimensional linear dynamical system with optional noise.
}
\details{
This function simulates a three-dimensional linear dynamical system.
It uses the specified time step and initial conditions to compute the system's
state over time. If a non-Infinite SNR is provided, Gaussian noise is added to
the system.
}
\examples{
# Simulate a 3D linear system with 100 time points and no noise
data <- linear3d_system(n = 100, init_conditions = c(1, 2, 3), dt = 0.01, snr = Inf)

}
