% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Higgins1990Table1}
\alias{Higgins1990Table1}
\title{Synthetic 3x3 Factorial Randomized Experiment}
\format{A data frame with 36 observations on the following 4 variables.
\describe{ 
     \item{Subject}{a factor with levels \code{"s1"} .. \code{"s36"}}
     \item{Row}{a factor with levels \code{"r1"} .. \code{"r3"}}
     \item{Column}{a factor with levels \code{"c1"} .. \code{"c3"}}
     \item{Response}{a numeric vector} 
}}
\source{
Higgins, J. J., Blair, R. C. and Tashtoush, S. (1990). The aligned
rank transform procedure.  \emph{Proceedings of the Conference on Applied
Statistics in Agriculture}. Manhattan, Kansas: Kansas State University, pp.
185-195.
}
\description{
Synthetic data from a balanced 3x3 factorial experiment with main effects,
no interaction, and independent and identically distributed (i.i.d.) Normal
errors.
}
\examples{

data(Higgins1990Table1)

## run aligned-rank transform and ANOVA on the data
## Note: because there is only one observation per Subject 
## in this dataset, we do not need to include Subject as 
## a grouping term in this formula. Indeed, if we did, 
## lmer would complain when we attempt the ANOVA.
m <- art(Response ~ Row*Column, data=Higgins1990Table1)
anova(m)

}
\seealso{
\code{\link{art}}, \code{\link{anova.art}}.
}
\keyword{datasets}

