% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_wave.R
\name{acoustic_indices}
\alias{acoustic_indices}
\title{Get acoustic complexity values}
\usage{
acoustic_indices(
  path,
  min_freq = NA,
  max_freq = NA,
  units = "samples",
  quiet = FALSE
)
}
\arguments{
\item{path}{Character. Path to wave file.}

\item{min_freq}{Numeric. Minimum frequency for acoustic complexity (see
\code{\link[soundecology:acoustic_complexity_index]{soundecology::acoustic_complexity()}})}

\item{max_freq}{Numeric. Maximum frequency for acoustic complexity (see
\code{\link[soundecology:acoustic_complexity_index]{soundecology::acoustic_complexity()}})}

\item{units}{Character. Wave file units for reading the file. Defaults to
"samples" (see \code{\link[tuneR:readWave]{tuneR::readWave()}}).}

\item{quiet}{Logical. Whether to suppress progress messages and other
non-essential updates.}
}
\value{
Returns a data frame with acoustic indices. Those prefaced with
\itemize{
\item \code{complx_} are from \code{\link[soundecology:acoustic_complexity_index]{soundecology::acoustic_complexity()}}
\item \code{bio_} are from \code{\link[soundecology:bioacoust_index]{soundecology::bioacoustic_index()}}
\item \code{div_} are from \code{\link[soundecology:acoustic_diversity]{soundecology::acoustic_diversity()}}
}
}
\description{
Wrapper for 'soundecology' package to calculate acoustic complexity, the
bioacoustic index, and acoustic diversity. See Value for details about
these indices.
}
\examples{
w <- tuneR::sine(440, duration = 300000) # > 5s
tuneR::writeWave(w, "test_wave.wav")
acoustic_indices("test_wave.wav")
acoustic_indices("test_wave.wav", quiet = TRUE)
unlink("test_wave.wav")
}
