% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aster_bands.R
\name{aster_bands}
\alias{aster_bands}
\title{Extract bands from multiple ASTER L1T hdf files}
\usage{
aster_bands(directory = getwd(), crop = "n", ext2crop = "none")
}
\arguments{
\item{directory}{Path to ASTER hdf file/ files folder. Assign as string (inside double quotes).
Either provide the path inside function or set up satellite image folder as the current working directory
before running the function.
To define current working directory, either use shortcut key Ctrl+Shift+H  or use \code{\link{setwd}} funtion.}

\item{ext2crop, crop}{Same as mentioned in \code{\link[ASIP]{arvi}}.}
}
\value{
File named "arvi_'date of satellite image acqisition'.tif" in the input folder.
}
\description{
Directly extract all bands in ASTER L1T hdf file/files in the input folder.
}
\note{
1. Windows users users should be careful while assigning directory. Use "/" to seperate folders not "\\".

2. The base of this function is provided by Land processes distributed active archive center (LP DAAC).
Raw code is customized to produce this function with additional functionalities and more ease of use. Authors are thankful to LP DAAC, NASA and USGS.
}
