% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dn2toa.R
\name{dn2toa}
\alias{dn2toa}
\title{DN to TOA conversion of optical bands}
\usage{
dn2toa(directory = getwd(), crop = "n", ext2crop = "none",
  op_directory = directory, b1 = 1, b2 = 1, b3 = 1, b4 = 1, b5 = 1,
  b6 = 1, b7 = 1)
}
\arguments{
\item{ext2crop, crop, directory}{Same as mentioned in \code{\link[ASIP]{arvi}}.}

\item{op_directory}{Specify the output directory (within double quotes). By default the input satellite image directory will be selected as the output directory.}

\item{b1}{By default Band1 will be processed to TOA reflectance. To cancel production of this band assign value 0.}

\item{b2}{By default Band2 will be processed to TOA reflectance. To cancel production of this band assign value 0.}

\item{b3}{By default Band3 will be processed to TOA reflectance. To cancel production of this band assign value 0.}

\item{b4}{By default Band4 will be processed to TOA reflectance. To cancel production of this band assign value 0.}

\item{b5}{By default Band5 will be processed to TOA reflectance. To cancel production of this band assign value 0.}

\item{b6}{By default Band6 will be processed to TOA reflectance. To cancel production of this band assign value 0.}

\item{b7}{By default Band7 will be processed to TOA reflectance. To cancel production of this band assign value 0.}
}
\value{
Each bands selected will produce corresponding image in *.tif format in the input directory.
}
\description{
Digital number (DN) bands to Top of Atmosphere (TOA) conversion.
}
\note{
1. This function followed by \code{\link[ASIP]{multi.indices}} is recommended only if user is intended to produce multiple indices
like ndvi & gemi other than running seperate function for each product to save processing time and resources.

Other important notes are mentioned in \code{\link[ASIP]{custom.eqn}}.
}
\examples{
library (raster)
library (rgdal)
# Finding the path of the sample satellite image directory.
# User may define paths directly like "/home/ur_folder" or "C:/ur_folder"
path <- system.file ("TM_sample", package = "ASIP")
shapefil <- paste0 (path, "/test.shp")
# Assign 0 values to band names which are not required
dn2toa (path, crop = "f", ext2crop = shapefil, b3=0, b4=0, b5=0, b6 = 0, b7 = 0)
}
\references{
\href{https://landsat.usgs.gov/sites/default/files/documents/Landsat8DataUsersHandbook.pdf}{USGS (2016) Landsat 8 (L8) data users handbook, version 2.}

Landsat 7 science data users handbook, NASA. Available at "https://landsat.gsfc.nasa.gov/wp-content/uploads/2016/08/Landsat7_Handbook.pdf".
}
