% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_G2A.R
\name{match.G2A}
\alias{match.G2A}
\title{Check the genomic relationship matrix G against
the pedigree relationship matrix A or vice versa}
\usage{
match.G2A(
  A = NULL,
  G = NULL,
  clean = TRUE,
  ord = TRUE,
  mism = FALSE,
  RMdiff = FALSE,
  message = TRUE
)
}
\arguments{
\item{A}{Input of the pedigree relationship matrix \eqn{\boldsymbol{A}} in full form (\eqn{na \times na}) (default = \code{NULL}).}

\item{G}{Input of the genomic relationship matrix \eqn{\boldsymbol{G}} in full form (\eqn{ng \times ng}) (default = \code{NULL}).}

\item{clean}{If \code{TRUE} generates new clean \eqn{\boldsymbol{G}} and \eqn{\boldsymbol{A}}
matrices in full form containing only matched individuals (default = \code{TRUE}).}

\item{ord}{If \code{TRUE} it will order by ascending order of individual names
both of the clean \eqn{\boldsymbol{A}} and \eqn{\boldsymbol{G}} matrices (default = \code{TRUE}).}

\item{mism}{If \code{TRUE} generates two data frames with mismatched individual names
from the \eqn{\boldsymbol{G}} and \eqn{\boldsymbol{A}} matrices (default = \code{FALSE}).}

\item{RMdiff}{If \code{TRUE} it generates the matrix (in lower diagonal row-wise sparse form) of matched
observations from both the \eqn{\boldsymbol{G}} and \eqn{\boldsymbol{A}} matrices.
This matrix can be used to identify inconsistent values between matched matrices, but it can be very large
(default = \code{FALSE}).}

\item{message}{If \code{TRUE} diagnostic messages are printed on screen (default = \code{TRUE}).}
}
\value{
A list with the following elements:
\itemize{
\item \code{Gclean}: a matrix with the portion of \eqn{\boldsymbol{G}} containing only matched individuals.
\item \code{Aclean}: a matrix with the portion of \eqn{\boldsymbol{A}} containing only matched individuals.
\item \code{mismG}: a vector containing the names of the individuals from matrix \eqn{\boldsymbol{G}} that are
missing in matrix \eqn{\boldsymbol{A}}.
\item \code{mismA}: a vector containing the names of the individuals from matrix \eqn{\boldsymbol{A}} that are
missing in matrix \eqn{\boldsymbol{G}}.
\item \code{RM}: a data frame with the observations from both the \eqn{\boldsymbol{G}} and \eqn{\boldsymbol{A}}
matched matrices, together with their absolute relationship difference.
\item \code{plotG2A}: scatterplot with the pairing of matched pedigree- against genomic-based
relationship values.
This graph might take a long to plot with large datasets.
}
}
\description{
Assesses a given genomic relationship matrix \eqn{\boldsymbol{G}} against the
pedigree relationship matrix \eqn{\boldsymbol{A}}, or vice versa,
to determine the matched and mismatched individuals.
If requested, it provides the cleaned versions containing only the matched individuals
between both matrices. The user should provide the matrices \eqn{\boldsymbol{G}}and
\eqn{\boldsymbol{A}} in full form (\eqn{ng \times ng} and \eqn{na \times na}, respectively).
Individual names should be assigned to \code{rownames} and \code{colnames} for both matrices.
}
\examples{
\donttest{
# Get A matrix.
A <- AGHmatrix::Amatrix(data = ped.pine)
A[1:5,1:5]
dim(A)

# Read and filter genotypic data.
M.clean <- qc.filtering(
 M = geno.pine655,
 maf = 0.05,
 marker.callrate = 0.2, ind.callrate = 0.20,
 na.string = "-9",
 plots = FALSE)$M.clean

# Get G matrix.
G <- G.matrix(M = M.clean, method = "VanRaden", na.string = "-9")$G
G[1:5, 1:5]
dim(G)

# Match G2A.
check <- match.G2A(
 A = A, G = G,
 clean = TRUE, ord = TRUE, mism = TRUE, RMdiff = TRUE)
ls(check)
dim(check$Aclean)
dim(check$Gclean)
check$Aclean[1:5, 1:5]
check$Gclean[1:5, 1:5]
head(check$mismG)
head(check$mismA)
check$plotG2A
head(check$RM)
}

}
