% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step1_down_rmse.R
\name{step1_down_rmse}
\alias{step1_down_rmse}
\title{Step1 Down Model Root Mean Square Error Calculation}
\usage{
step1_down_rmse(
  data,
  y,
  .time,
  K = NULL,
  C = NULL,
  parms,
  reparameterisation = FALSE
)
}
\arguments{
\item{data}{Dataframe containing accelerated stability data (required).}

\item{y}{Name of decreasing variable (e.g. concentration) contained within data (required).}

\item{.time}{Time variable contained within data (required).}

\item{K}{Kelvin variable (numeric or column name) (optional).}

\item{C}{Celsius variable (numeric or column name) (optional).}

\item{parms}{Values for the parameters as a list - k1, k2, k3, and c0. If multiple are provided all combinations will be used (required).}

\item{reparameterisation}{Use alternative parameterisation of the one-step
model which aims to reduce correlation between k1 and k2.}
}
\value{
A data frame containing one row for each RMSE calculation
}
\description{
Calculate Root Mean Square Error (RMSE) for the one-step Šesták–Berggren kinetic model.
}
\details{
Calculate RMSE for the one-step Šesták–Berggren kinetic (non-linear) model using
user provided parameters.
}
\examples{
#load antigenicity and potency data.
data(antigenicity)
data(potency)

#Basic use of the step1_down_rmse function with C column defined.
rmse1 <- step1_down_rmse(data = antigenicity, y = "conc", .time = "time",
 C = "Celsius", parms = list(c0 = c(96,98,100), k1 = c(42,45),
  k2 = c(12000,12500), k3 = c(8,9,10)))

#Basic use of the step1_down_rmse function with K column defined.
rmse2 <- step1_down_rmse(data = antigenicity, y = "conc", .time = "time",
 K = "K", parms = list(c0 = c(98), k1 = c(42,45), k2 = c(12500), k3 = c(8,9)))

#reparameterisation is TRUE.
rmse3 <- step1_down_rmse(data = antigenicity, y = "conc", .time = "time",
 C = "Celsius", parms = list(c0 = c(100,95), k1 = c(2,2.5), k2 = c(12000,13000),
  k3 = c(9,10)), reparameterisation = TRUE)

}
