% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ActivePathways.r
\name{enrichmentAnalysis}
\alias{enrichmentAnalysis}
\title{Perform pathway enrichment analysis on an ordered list of genes}
\usage{
enrichmentAnalysis(genelist, gmt, background)
}
\arguments{
\item{genelist}{character vector of gene names, in decreasing order
of significance}

\item{gmt}{GMT object}

\item{background}{character vector of gene names. List of all genes being used
as a statistical background}
}
\value{
a data.table of terms with the following columns:
  \describe{
    \item{term_id}{The id of the term}
    \item{term_name}{The full name of the term}
    \item{adjusted_p_val}{The associated p-value adjusted for multiple testing}
    \item{term_size}{The number of genes annotated to the term}
    \item{overlap}{A character vector of the genes that overlap between the
       term and the query}
  }
}
\description{
Perform pathway enrichment analysis on an ordered list of genes
}
\keyword{internal}
