% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BayesFor2GMM.R
\name{BayesFor2GMM}
\alias{BayesFor2GMM}
\title{Posterioris of Bayes Theorem for a two group GMM}
\usage{
BayesFor2GMM(Data, Means, SDs, Weights, IsLogDistribution = Means * 0,
  Ind1 = c(1:floor(length(Means)/2)), Ind2 = c((floor(length(Means)/2)
  + 1):length(Means)), PlotIt = 0, CorrectBorders = 0)
}
\arguments{
\item{Data}{vector (1:N) of data points}

\item{Means}{vector[1:L] of Means of Gaussians (of GMM),L == Number of Gaussians}

\item{SDs}{vector of standard deviations, estimated Gaussian Kernels, has to be the same length as Means}

\item{Weights}{vector of relative number of points in Gaussians (prior probabilities), has to be the same length as Means}

\item{IsLogDistribution}{Optional, ==1 if distribution(i) is a LogNormal, default vector of zeros of length L}

\item{Ind1}{indices from (1:C) such that [M(Ind1),S(Ind1) ,W(Ind1) ]is one mixture, [M(Ind2),S(Ind2) ,W(Ind2) ] the second mixture default Ind1= 1:C/2, Ind2= C/2+1:C}

\item{Ind2}{indices from (1:C) such that [M(Ind1),S(Ind1) ,W(Ind1) ]is one mixture, [M(Ind2),S(Ind2) ,W(Ind2) ] the second mixture default Ind1= 1:C/2, Ind2= C/2+1:C}

\item{PlotIt}{Optional, Default: FALSE; TRUE do a Plot}

\item{CorrectBorders}{Optional, ==TRUE data at right borders of GMM distribution will be assigned to last gaussian, left border vice versa. (default ==FALSE) normal Bayes Theorem}
}
\value{
List With 
\describe{
  \item{Posteriors:}{(1:N,1:L) of Posteriors corresponding to Data}
  \item{NormalizationFactor:}{(1:N) denominator of Bayes theorem corresponding to Data}
  
}
}
\description{
Calculates the posterioris of Bayes theorem, splits the GMM in two groups beforehand.
}
\details{
See conference presentation for further explanation.
}
\references{
Thrun M.C.,Ultsch, A.: Models of Income Distributions for Knowledge Discovery, European Conference on Data Analysis, DOI 10.13140/RG.2.1.4463.0244, Colchester 2015.

\strong{See Also}

BayesDecisionBoundaries,AdaptGauss
}
\author{
Alfred Ultsch, Michael Thrun
}
