% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RandomLogGMM.R
\name{RandomLogGMM}
\alias{RandomLogGMM}
\title{Random Number Generator for Log or Gaussian Mixture Model}
\usage{
RandomLogGMM(Means, SDs, Weights, IsLogDistribution,
  TotalNoPoints = 1000)
}
\arguments{
\item{Means}{vector[1:L] of Means of Gaussians (of GMM)}

\item{SDs}{vector of standard deviations, estimated Gaussian Kernels, has to be the same length as Means}

\item{Weights}{vector of relative number of points in Gaussians (prior probabilities), has to be the same length as Means}

\item{IsLogDistribution}{Optional, ==1 if distribution(i) is a LogNormal, default vector of Zeros of Length L}

\item{TotalNoPoints}{Optional, number of point for log or GMM generated}
}
\value{
Returns vector of [1:TotalNoPoints] of genrated points for log oder gaussian mixture model
}
\description{
Function finds the intersections of Gaussians or LogNormals
}
\author{
Alfred Ultsch,Michael Thrun, Rabea Griese

\strong{See Also}

QQplotGMM,Chi2testMixtures
}
