% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adherer.R
\name{plot.CMA0}
\alias{plot.CMA0}
\title{Plot CMA0 objects.}
\usage{
\method{plot}{CMA0}(x, ..., patients.to.plot = NULL, duration = NA,
  align.all.patients = FALSE, show.period = c("dates", "days")[2],
  period.in.days = 90, show.legend = TRUE, cex = 1, cex.axis = 0.75,
  cex.lab = 1, col.cats = cm.colors, lty.event = "solid", lwd.event = 2,
  pch.start.event = 15, pch.end.event = 16, col.continuation = "black",
  lty.continuation = "dotted", lwd.continuation = 1, col.na = "lightgray",
  bw.plot = FALSE, print.CMA = TRUE, plot.CMA = TRUE,
  CMA.plot.ratio = 0.1)
}
\arguments{
\item{x}{A \emph{\code{CMA0}} or derived object, representing the CMA to
plot}

\item{...}{other possible parameters}

\item{patients.to.plot}{A vector of \emph{strings} containing the list of
patient IDs to plot (a subset of those in the \code{cma} object), or
\code{NULL} for all}

\item{duration}{A \emph{number}, the total duration (in days) of the whole
period to plot; in \code{NA} it is automatically determined from the event
data such that the whole dataset fits.}

\item{align.all.patients}{\emph{Logical}, should all patients be aligned
(i.e., the actual dates are discarded and all plots are relative to the
earliest date)?}

\item{show.period}{A \emph{string}, if "dates" show the actual dates at the
regular grid intervals, while for "days" (the default) shows the days since
the beginning; if \code{align.all.patients == TRUE}, \code{show.period} is
taken as "days".}

\item{period.in.days}{The \emph{number} of days at which the regular grid is
drawn.}

\item{show.legend}{\emph{Logical}, should the legend be drawn?}

\item{cex, cex.axis, cex.lab}{\emph{numeric} values specifying the cex of the
various types of text.}

\item{col.cats}{A \emph{color} or a \emph{function} that specifies the single
colour or the colour palette used to plot the different medication; by
default \code{cm.colors}.}

\item{lty.event, lwd.event, pch.start.event, pch.end.event}{The style of the
event (line style, width, and start and end symbols).}

\item{col.continuation, lty.continuation, lwd.continuation}{The style of the
"continuation" lines connecting consecutive events (colour, line style and
width).}

\item{col.na}{The colour used for missing event data.}

\item{bw.plot}{\emph{Logical}, should the plot use grayscale only (i.e., the
\code{\link[grDevices]{gray.colors}} function)?}

\item{print.CMA}{\emph{Logical}, should the CMA values be printed?}

\item{plot.CMA}{\emph{Logical}, should the CMA values be represented
graphically?}

\item{CMA.plot.ratio}{A \emph{number}, the proportion of the total horizontal
plot space to be allocated to the CMA plot.}
}
\description{
Plots the events (prescribing or dispensing) data encapsulated in a basic
CMA0 object.
}
\details{
The x-axis represents time (either in days since the earliest date or as
actual dates), with consecutive events represented as ascending on the y-axis.

Each event is represented as a segment with style \code{lty.event} and line
width \code{lwd.event} starting with a \code{pch.start.event} and ending with
a \code{pch.end.event} character, coloured with a unique color as given by
\code{col.cats}, extending from its start date until its end date.
Consecutive events are thus represented on consecutive levels of the y-axis
and are connected by a "continuation" line with \code{col.continuation}
colour, \code{lty.continuation} style and \code{lwd.continuation} width;
these continuation lines are purely visual guides helping to perceive the
sequence of events, and carry no information about the availability of
medication in this interval.

When several patients are displayed on the same plot, they are organized
vertically, and alternating bands (white and gray) help distinguish
consecutive patients.
Implicitly, all patients contained in the \code{cma} object will be plotted,
but the \code{patients.to.plot} parameter allows the selection of a subset
of patients.
}
\examples{
cma0 <- CMA0(data=med.events,
             ID.colname="PATIENT_ID",
             event.date.colname="DATE",
             event.duration.colname="DURATION",
             event.daily.dose.colname="PERDAY",
             medication.class.colname="CATEGORY",
             followup.window.start=0,
             followup.window.start.unit="days",
             followup.window.duration=2*365,
             followup.window.duration.unit="days",
             observation.window.start=30,
             observation.window.start.unit="days",
             observation.window.duration=365,
             observation.window.duration.unit="days",
             date.format="\%m/\%d/\%Y",
             summary="Base CMA");
plot(cma0, patients.to.plot=c("1","2"));
}
