% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matching_function.R
\name{prune_event_durations}
\alias{prune_event_durations}
\title{Prune event durations.}
\usage{
prune_event_durations(
  data,
  include = c("special periods", "treatment interruptions", "dosage changes"),
  medication.class.colnames = data$medication.class.colnames,
  days.within.out.date.1,
  days.within.out.date.2,
  keep.all = TRUE,
  suppress.warnings = FALSE,
  return.data.table = FALSE,
  ...
)
}
\arguments{
\item{data}{A \emph{\code{list}}, the output of \code{compute_event_durations}.}

\item{include}{A \emph{\code{Vector}} of \emph{strings} indicating whether to include
dosage changes, special periods, and/or treatment interruptions.}

\item{medication.class.colnames}{A \emph{\code{Vector}} of \emph{strings}, the
name(s) of the column(s) in the \code{event_durations} element of \code{data} to
identify medication classes. Defaults to the columns used in \code{compute_event_durations}.}

\item{days.within.out.date.1}{event durations from before the dosage change, special period, or
treatment interruptions are removed if there is a new dispensing event within the
number of days specified as \emph{integer} after the dosage change or end of the special
period/treatment interruption.}

\item{days.within.out.date.2}{event durations from before dosage change, special period,
or treatment interruption are removed if there is \emph{NO} new dispensing event within the
number of days specified as \emph{integer} after the dosage change or end of the special
period/treatment interruption.}

\item{keep.all}{\emph{Logical}, should events be kept and marked for removal?
If \code{TRUE}, a new column \code{.prune.event} will be added to \code{event_durations},
if \code{FALSE} the events will be removed from the output.}

\item{suppress.warnings}{\emph{Logical}, if \code{TRUE} don't show any
warnings.}

\item{return.data.table}{\emph{Logical}, if \code{TRUE} return a
\code{data.table} object, otherwise a \code{data.frame}.}

\item{...}{other possible parameters.}
}
\value{
A \code{data.frame} or \code{data.table}, the pruned event_durations.
}
\description{
Flags or removes leftover supply durations after dosage changes, the end of a special period,
or treatment interruption.
The function accepts the raw list output of \code{compute_event_durations} and additional arguments
to specify event durations that need to be removed.
}
\details{
Dosage changes, special periods, and treatment interruptions may lead to overestimation of
implementation, e.g. if patients get a refill after discharge from hospital and don't continue to use
their previous supply. Likewise, it may also lead to overestimation of persistence, e.g. when
patients discontinue treatments after the end of a special period or treatment interruption.
}
\examples{
\dontrun{
# select medication class of interest and compute event durations

disp_data <- durcomp.dispensing[ID == 3 & grepl("J01EE01", ATC.CODE)]
presc_data <- durcomp.prescribing[ID == 3 & grepl("J01EE01", ATC.CODE)]

# compute event durations
event_durations_list <- compute_event_durations(disp.data = disp_data,
                                                presc.data = presc_data,
                                                special.periods.data = durcomp.hospitalisation,
                                                ID.colname = "ID",
                                                presc.date.colname = "DATE.PRESC",
                                                disp.date.colname = "DATE.DISP",
                                                date.format = "\%Y-\%m-\%d",
                                                medication.class.colnames = c("ATC.CODE",
                                                                              "UNIT",
                                                                              "FORM"),
                                                total.dose.colname = "TOTAL.DOSE",
                                                presc.daily.dose.colname = "DAILY.DOSE",
                                                presc.duration.colname = "PRESC.DURATION",
                                                visit.colname = "VISIT",
                                                force.init.presc = TRUE,
                                                force.presc.renew = TRUE,
                                                split.on.dosage.change = TRUE,
                                                trt.interruption = "carryover",
                                                special.periods.method = "carryover",
                                                suppress.warnings = FALSE,
                                                return.data.table = TRUE,
                                                progress.bar = FALSE)

# prune event durations
event_durations <- prune_event_durations(event_durations_list,
                                         include = c("special periods"),
                                         medication.class.colnames = "ATC.CODE",
                                         days.within.out.date.1 = 7,
                                         days.within.out.date.2 = 30,
                                         keep.all = FALSE)
       }
}
