% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/team_advance_stats.R
\name{team_advanced_stats}
\alias{team_advanced_stats}
\title{Team advanced statistics}
\usage{
team_advanced_stats(df1, df2, m)
}
\arguments{
\item{df1}{Should be a Data Frame that represents the team statistics. This parameter has to be in the format provided by the team_stats() function.}

\item{df2}{Should be a Data Frame that represents the rival statistics. This parameter has to be in the format provided by the team_stats() function.}

\item{m}{should be a number. This parameter has to be the duration of a single game.}
}
\value{
Data frame with the following advanced statistics calculated:
       \itemize{
                \item Offensive Rating (ORtg)
                \item Defensive Rating (DRtg)
                \item Net Rating (NetRtg)
                \item Pace (Pace)
                \item Three rating (3Par)
                \item True shooting percentage (TS\%)
                \item Efficiency Field Goals percentage (eFG\%)
                \item Assists percentage (AST\%)
                \item Assist to Turnover Ratio (AST/TO)
                \item Assist Ratio (ASTRATIO)
                \item Offensive rebounds percentage (ORB\%)
                \item Defensive rebounds percentage (DRB\%)
                \item Total rebounds percentage (TRB\%)
                \item Turnover percentage (TOV\%)
                \item Free Throw rating (FTr)
                \item Opponent Efficiency Field Goals percentage (Opp eFG\%)
                \item Opponent Turnover percentage (Opp TOV\%)
                \item Opponent Defensive rebounds percentage (Opp DRB\%)
                \item Opponent Free Throw rating (Opp FTr)
        }
}
\description{
This function allows the calculation of advanced team's statistics.
}
\examples{
df1 <- data.frame("G" = c(71), "MP" = c(17090), "FG" = c(3006),
"FGA" = c(6269),"Percentage FG" = c(0.48), "3P" = c(782),
"3PA" = c(2242), "Percentage 3P" = c(0.349),  "2P" = c(2224),
"2PA" = c(4027), "Percentage 2P" = c(0.552), "FT" = c(1260),
"FTA FG" = c(1728),  "Percentage FT" = c(0.729), "ORB" = c(757),
"DRB" = c(2490),"TRB" = c(3247),"AST" = c(1803),"STL" = c(612),
"BLK" = c(468),   "TOV" = c(1077),  "PF" = c(1471),
"PTS" = c(8054),  "+/-" = c(0))

df2 <- data.frame("G" = c(71), "MP" = c(17090), "FG" = c(2773),
"FGA" = c(6187),"Percentage FG" = c(0.448), "3P" = c(827),
"3PA" = c(2373), "Percentage 3P" = c(0.349),  "2P" = c(1946),
"2PA" = c(3814), "Percentage 2P" = c(0.510), "FT" = c(1270),
"FTA FG" = c(1626),  "Percentage FT" = c(0.781), "ORB" = c(668),
"DRB" = c(2333),"TRB" = c(3001),  "AST" = c(1662),"STL" = c(585),
"BLK" = c(263),   "TOV" = c(1130),  "PF" = c(1544),
"PTS" = c(7643),  "+/-" = c(0))

m <- 48

team_advanced_stats(df1,df2,m)

}
