% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iplot_abundance.R
\name{iplot_abundance}
\alias{iplot_abundance}
\title{Plot of the Relative Abundance of the Pollen Types}
\usage{
iplot_abundance(data, n.types = 15, y.start = NULL, y.end = NULL,
  interpolation = TRUE, int.method = "lineal", col.bar = "#E69F00",
  type.plot = "static", export.plot = FALSE, export.format = "pdf",
  ...)
}
\arguments{
\item{data}{A \code{data.frame} object including the general database where calculation of the pollen season must be applied. This \code{data.frame} must include a first column in \code{Date} format and the rest of columns in \code{numeric} format belonging to each pollen type by column.}

\item{n.types}{A \code{numeric} (\code{integer}) value specifying the number of the most abundant pollen types that must be represented in the plot of the relative abundance. A more detailed information about the selection of the considered pollen types may be consulted in \strong{Details}. The \code{n.types} argument will be \code{15} types by default.}

\item{y.start, y.end}{A \code{numeric} (\code{integer}) value specifying the period selected to calculate relative abundances of the pollen types (\code{start year _ end year}). If \code{y.start} and \code{y.end} are not specified (\code{NULL}), the entire database will be used to generate the pollen calendar. The \code{y.start} and \code{y.end} arguments will be \code{NULL} by default.}

\item{interpolation}{A \code{logical} value. If \code{FALSE} the interpolation of the pollen data is not applicable. If \code{TRUE} an interpolation of the pollen series will be applied to complete the gaps with no data before the calculation of the pollen season. The \code{interpolation} argument will be \code{TRUE} by default. A more detailed information about the interpolation method may be consulted in \strong{Details}.}

\item{int.method}{A \code{character} string specifying the method selected to apply the interpolation method in order to complete the pollen series. The implemented methods that may be used are: \code{"lineal"}, \code{"movingmean"}, \code{"spline"} or \code{"tseries"}. The \code{int.method} argument will be \code{"lineal"} by default.}

\item{col.bar}{A \code{character} string specifying the color of the bars to generate the graph showing the relative abundances of the pollen types. The \code{color} argument will be \code{#E69F00} by default, but any color may be selected.}

\item{type.plot}{A \code{character} string specifying the type of plot selected to show the plot showing the relative abundance of the pollen types. The implemented types that may be used are: \code{static} generates a static \strong{ggplot} object and \code{dynamic} generates a dynamic \strong{plotly} object.}

\item{export.plot}{A \code{logical} value specifying if a plot saved in the working directory will be required or not. If \code{FALSE} graphical results will only be displayed in the active graphics window. If \code{TRUE} graphical results will be displayed in the active graphics window and also a \emph{pdf} or \emph{png} file (according to the \code{export.format} argument) will be saved within the \emph{plot_AeRobiology} directory automatically created in the working directory. This argument is applicable only for \code{"static"} plots. The \code{export.plot} will be \code{FALSE} by default.}

\item{export.format}{A \code{character} string specifying the format selected to save the plot showing the relative abundance of the pollen types. The implemented formats that may be used are: \code{"pdf"} and \code{"png"}. This argument is applicable only for \code{"static"} plots. The \code{export.format} will be \code{"pdf"} by default.}

\item{...}{Other additional arguments may be used to customize the exportation of the plots using \code{"pdf"} or \code{"png"} files and therefore arguments from \code{\link[grDevices]{pdf}} and \code{\link[grDevices]{png}} functions (\pkg{grDevices} package) may be implemented. For example, for \emph{pdf} files the user may custom the arguments: \code{width}, \code{height}, \code{family}, \code{title}, \code{fonts}, \code{paper}, \code{bg}, \code{fg}, \code{pointsize...}; and for \emph{png} files the user may custom the arguments: \code{width}, \code{height}, \code{units}, \code{pointsize}, \code{bg}, \code{res...}}
}
\value{
This function returns different results:\cr
\cr
\code{plot} in the active graphics window displaying the pollen calendar generated by the user. This \code{plot} may be included in an object by assignment operators.\cr
\cr
\code{data.frame} including the yearly average pollen amounts for each pollen types used to generate the pollen of the relative abundance. This \code{data.frame} will be included in an object named \code{annual.sum.data}.\cr
\cr
If \code{export.plot = FALSE} graphical results will only be displayed in the active graphics window as \strong{ggplot} graph. Additional characteristics may be incorporated to the plot by \code{\link[ggplot2]{ggplot}} syntax (see \pkg{ggplot2} package).\cr
\cr
If \code{export.plot = TRUE} and \code{export.format = pdf} a \emph{pdf} file with the plot will be saved within the \emph{plot_AeRobiology} directory created in the working directory. This option is applicable only for \code{"static"} plots. Additional characteristics may be incorporated to the exportation as \emph{pdf} file (see \pkg{grDevices} package).\cr
\cr
If \code{export.plot = TRUE} and \code{export.format = png} a \emph{png} file with the plot will be saved within the \emph{plot_AeRobiology} directory created in the working directory. This option is applicable only for \code{"static"} plots. Additional characteristics may be incorporated to the exportation as \emph{png} file (see \pkg{grDevices} package).\cr
\cr
If \code{type.plot = dynamic} graphical results will be displayed in the active Viewer window as \strong{plotly} graph. Additional characteristics may be incorporated to the plot by \code{\link[plotly]{plotly}} syntax (see \pkg{plotly} package).
}
\description{
Generates a barplot based on the relative abundance (as percentage) in the air of the pollen types with respect to the total amounts
}
\details{
This function allows to calculate the relative abundance of the pollen types in the air from a database and to display a barplot with the percentage representation of the main pollen types as the graph reported by \emph{Rojo et al. (2016)}. This plot will be generated only for the specified number of the most abundant pollen types using the \code{n.types} argument by the user.\cr
\cr
Pollen time series frequently have different gaps with no data and this fact could be a problem for the calculation of specific methods for defining the pollen season even providing incorrect results. In this sense by default a linear interpolation will be carried out to complete these gaps before to define the pollen season (\code{interpolation = TRUE}). Additionally, the users may select other interpolation methods using the \code{int.method} argument, as \code{"lineal"}, \code{"movingmean"}, \code{"spline"} or \code{"tseries"}. For more information to see the \code{\link{interpollen}} function.
}
\examples{
data("munich")
iplot_abundance (munich, interpolation = FALSE, export.plot = FALSE)
}
\references{
Rojo, J., Rapp, A., Lara, B., Sabariego, S., Fernandez_Gonzalez, F. and Perez_Badia, R., 2016. Characterisation of the airborne pollen spectrum in Guadalajara (central Spain) and estimation of the potential allergy risk. \emph{Environmental Monitoring and Assessment}, 188(3), p.130.
}
\seealso{
\code{\link{interpollen}}
}
