#' Dataset: Pomegranate data
#'
#' @description An experiment was conducted with the objective of studying different
#' products to reduce the loss of mass in postharvest of pomegranate fruits.
#' The experiment was conducted in a completely randomized design with four
#' replications. Treatments are: T1: External Wax; T2: External + Internal Wax;
#' T3: External Orange Oil; T4: Internal + External Orange Oil; T5: External
#' sodium hypochlorite; T6: Internal + External sodium hypochlorite
#'
#' @docType data
#'
#' @usage data(pomegranate)
#'
#' @format data.frame containing data set
#'   \describe{
#'   \item{\code{trat}}{Categorical vector with treatments}
#'   \item{\code{WL}}{Numeric vector weights loss}
#'   \item{\code{SS}}{Numeric vector solid soluble}
#'   \item{\code{AT}}{Numeric vector titratable acidity}
#'   \item{\code{ratio}}{Numeric vector with ratio (SS/AT)}
#'   }
#' @seealso \link{cloro}, \link{enxofre}, \link{laranja}, \link{mirtilo}, \link{porco}, \link{sensorial}, \link{simulate1}, \link{simulate2}, \link{simulate3}, \link{tomate}, \link{weather}, \link{phao}, \link{passiflora}
#'
#' @keywords datasets
#'
#' @examples
#' data(pomegranate)
"pomegranate"
