% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mitscherlich_analysis.R
\name{mitscherlich}
\alias{mitscherlich}
\title{Analysis: Mitscherlich Regression}
\usage{
mitscherlich(
  trat,
  resp,
  A = NA,
  b = NA,
  e = NA,
  ylab = "Dependent",
  xlab = "Independent",
  theme = theme_classic(),
  legend.position = "top",
  error = "SE",
  r2 = "all",
  point = "all",
  width.bar = NA,
  scale = "none",
  textsize = 12,
  pointsize = 4.5,
  linesize = 0.8,
  pointshape = 21,
  comment = NA
)
}
\arguments{
\item{trat}{Numeric vector with dependent variable.}

\item{resp}{Numeric vector with independent variable.}

\item{A}{Set an initial value for "A"}

\item{b}{Set an initial value for "b"}

\item{e}{Set an initial value for "e"}

\item{ylab}{Variable response name (Accepts the \emph{expression}() function)}

\item{xlab}{treatments name (Accepts the \emph{expression}() function)}

\item{theme}{ggplot2 theme (\emph{default} is theme_bw())}

\item{legend.position}{legend position (\emph{default} is "top")}

\item{error}{Error bar (It can be SE - \emph{default}, SD or FALSE)}

\item{r2}{coefficient of determination of the mean or all values (\emph{default} is all)}

\item{point}{defines whether you want to plot all points ("all") or only the mean ("mean")}

\item{width.bar}{Bar width}

\item{scale}{Sets x scale (\emph{default} is none, can be "log")}

\item{textsize}{Font size}

\item{pointsize}{shape size}

\item{linesize}{line size}

\item{pointshape}{format point (default is 21)}

\item{comment}{Add text after equation}
}
\value{
The function returns a list containing the coefficients and their respective values of p; statistical parameters such as AIC, BIC, pseudo-R2, RMSE (root mean square error); largest and smallest estimated value and the graph using ggplot2 with the equation automatically.
}
\description{
This function performs Mitscherlich regression analysis.
}
\details{
The Mitscherlich model is defined by:
\deqn{y = A \times (1-e^{-eb-ex})}

where "y" is the yield obtained when "b" units of a nutrient are in the soil and
"x" units of it are added as fertilizer, "A" is the maximum yield, and "e" is the
proportionality factor, has recently received increasing interest.
}
\examples{
library(AgroReg)
data("granada")
attach(granada)
mitscherlich(time,WL)
}
\author{
Gabriel Danilo Shimizu

Leandro Simoes Azeredo Goncalves
}
