% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LM_i_analysis.R
\name{LM_i}
\alias{LM_i}
\title{Analysis: Linear, quadratic, quadratic inverse, cubic and quartic without intercept}
\usage{
LM_i(
  trat,
  resp,
  sample.curve = 1000,
  ylab = "Dependent",
  error = "SE",
  ic = FALSE,
  fill.ic = "gray70",
  alpha.ic = 0.5,
  xlab = "Independent",
  degree = NA,
  theme = theme_classic(),
  legend.position = "top",
  point = "all",
  r2 = "all",
  width.bar = NA,
  scale = "none",
  textsize = 12,
  pointsize = 4.5,
  linesize = 0.8,
  pointshape = 21,
  fillshape = "gray",
  colorline = "black",
  round = NA,
  xname.formula = "x",
  yname.formula = "y",
  comment = NA,
  fontfamily = "sans"
)
}
\arguments{
\item{trat}{Numeric vector with dependent variable.}

\item{resp}{Numeric vector with independent variable.}

\item{sample.curve}{Provide the number of observations to simulate curvature (default is 1000)}

\item{ylab}{Dependent variable name (Accepts the \emph{expression}() function)}

\item{error}{Error bar (It can be SE - \emph{default}, SD or FALSE)}

\item{ic}{Add interval of confidence}

\item{fill.ic}{Color interval of confidence}

\item{alpha.ic}{confidence interval transparency level}

\item{xlab}{Independent variable name (Accepts the \emph{expression}() function)}

\item{degree}{degree of the polynomial (0.5, 1, 2, 3 or 4)}

\item{theme}{ggplot2 theme (\emph{default} is theme_classic())}

\item{legend.position}{legend position (\emph{default} is "top")}

\item{point}{defines whether you want to plot all points ("all") or only the mean ("mean")}

\item{r2}{coefficient of determination of the mean or all values (\emph{default} is all)}

\item{width.bar}{Bar width}

\item{scale}{Sets x scale (\emph{default} is none, can be "log")}

\item{textsize}{Font size}

\item{pointsize}{shape size}

\item{linesize}{line size}

\item{pointshape}{format point (default is 21)}

\item{fillshape}{Fill shape}

\item{colorline}{Color lines}

\item{round}{round equation}

\item{xname.formula}{Name of x in the equation}

\item{yname.formula}{Name of y in the equation}

\item{comment}{Add text after equation}

\item{fontfamily}{Font family}
}
\value{
The function returns a list containing the coefficients and their respective values of p; statistical parameters such as AIC, BIC, pseudo-R2, RMSE (root mean square error); largest and smallest estimated value and the graph using ggplot2 with the equation automatically.
}
\description{
Linear, quadratic, quadratic inverse, cubic and quartic regression.
}
\details{
The linear model is defined by:
\deqn{y = \beta_1\cdot x}
The quadratic model is defined by:
\deqn{y = \beta_1\cdot x + \beta_2\cdot x^2}
The quadratic inverse model is defined by:
\deqn{y = \beta_1\cdot x + \beta_2\cdot x^{0.5}}
The cubic model is defined by:
\deqn{y = \beta_1\cdot x + \beta_2\cdot x^2 + \beta_3\cdot x^3}
The quartic model is defined by:
\deqn{y = \beta_1\cdot x + \beta_2\cdot x^2 + \beta_3\cdot x^3+ \beta_4\cdot x^4}
}
\examples{
library(AgroReg)
data("aristolochia")
attach(aristolochia)
LM(trat,resp, degree = 3)
}
\author{
Gabriel Danilo Shimizu

Leandro Simoes Azeredo Goncalves
}
\keyword{linear}
\keyword{regression}
