% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pas_addCommunityRegion.R
\name{pas_addCommunityRegion}
\alias{pas_addCommunityRegion}
\title{Add an air district to PurpleAir Synoptic Data}
\usage{
pas_addCommunityRegion(pas = NULL)
}
\arguments{
\item{pas}{PurpleAir Synoptic \emph{pas} object.}
}
\value{
A pa_synoptic dataframe
}
\description{
Adds a community region (if any) to a pa_synoptic object via the 
pa_synotpic object via pre-defined labeling shcema.
}
\note{
As of 2020-04-14, only California air basins is supported.
}
\examples{
\donttest{
library(AirSensor)

initializeMazamaSpatialUtils()

pas_enhanced <-
  example_pas_raw \%>\% 
  pas_addSpatialMetadata() \%>\% 
  pas_addCommunityRegion()
}
}
\seealso{
\link{pas_enhanceData}
}
