% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pas_filterNear.R
\name{pas_filterNear}
\alias{pas_filterNear}
\title{Find PurpleAir sensors within radial distance}
\usage{
pas_filterNear(pas = NULL, longitude = NULL, latitude = NULL, radius = "1 km")
}
\arguments{
\item{pas}{PurpleAir \emph{pas} object.}

\item{longitude}{a Target longitude.}

\item{latitude}{a Target latitude.}

\item{radius}{Distance from target with unit (i.e "15 km").}
}
\value{
A subset of the given \emph{pas} object.
}
\description{
Filter for PurpleAir sensors within a specified distance from 
specified target coordinates.
}
\details{
\code{radius} Should be a numeric string with a metric unit 
separated by a space, such as \code{"250 m"}.
}
\examples{
library(AirSensor)

# Near Diamond Bar, CA
pas <- example_pas
diamond_bar <-
  pas \%>\%
  pas_filterNear(
    longitude = -117.820833,
    latitude = 34.001667, 
    radius = "20 km"
  )
                 
if ( interactive() ) {
  pas_leaflet(diamond_bar)
}

}
\seealso{
\link{pas_filter}

\link{pas_filterArea}
}
