% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensor_load.R
\name{sensor_load}
\alias{sensor_load}
\title{Load hourly-aggregated PurpleAir data}
\usage{
sensor_load(
  collection = "scaqmd",
  startdate = NULL,
  enddate = NULL,
  days = 7,
  timezone = "America/Los_Angeles"
)
}
\arguments{
\item{collection}{Name associated with the collection.}

\item{startdate}{Desired start datetime (ISO 8601).}

\item{enddate}{Desired end datetime (ISO 8601).}

\item{days}{Number of days of data to include (7 or 45).}

\item{timezone}{Timezone used to interpret start and end dates.}
}
\value{
An object of class "airsensor".
}
\description{
A pre-generated \code{airsensor} object will be loaded for
the given time interval. Archived data for SCAQMD sensors go back to 
January, 2018.

Dates can be anything that is understood by 
\code{lubrdiate::parse_date_time()} including either of the following 
recommended formats:

\itemize{
\item{\code{"YYYYmmdd"}}
\item{\code{"YYYY-mm-dd"}}
}

By default, the current week is loaded.
}
\examples{
\donttest{
library(AirSensor)

setArchiveBaseUrl("http://data.mazamascience.com/PurpleAir/v1")

sensor_load("scaqmd", 20200411, 20200521) \%>\%
  PWFSLSmoke::monitor_timeseriesPlot(style = 'gnats')
}
}
\seealso{
\link{sensor_loadMonth}

\link{sensor_loadYear}
}
