% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-SimParam.R
\name{SimParam_new}
\alias{SimParam_new}
\title{Create new simulation}
\arguments{
\item{founderPop}{an object of \code{\link{MapPop-class}}}
}
\description{
Starts the process of building a new simulation 
by creating a new SimParam object and assigning a founder 
population to the class. It is recommended that you save the 
object with the name "SP", because subsequent functions will 
check your global enviroment for an object of this name if 
their simParam arguments are NULL. This allows you to call 
these functions without explicitly supplying a simParam 
argument with every call.
}
\section{Usage}{
 SimParam$new(founderPop)
}

\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)

}
