% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popSummary.R
\name{genParam}
\alias{genParam}
\title{Sumarize genetic parameters}
\usage{
genParam(pop, simParam = NULL)
}
\arguments{
\item{pop}{an object of \code{\link{Pop-class}}}

\item{simParam}{an object of \code{\link{SimParam}}}
}
\value{
\describe{
\item{varA}{an nTrait by nTrait matrix of additive genetic variances}
\item{varD}{an nTrait by nTrait matrix of dominance genetic variances}
\item{varAA}{an nTrait by nTrait matrix of additive-by-additive genetic variances}
\item{varG}{an nTrait by nTrait matrix of total genetic variances}
\item{genicVarA}{an nTrait vector of additive genic variances}
\item{genicVarD}{an nTrait vector of dominance genic variances}
\item{genicVarAA}{an nTrait vector of additive-by-additive genic variances}
\item{genicVarG}{an nTrait vector of total genic variances}
\item{covA_HW}{an nTrait vector of additive covariances due to non-random mating}
\item{covD_HW}{an nTrait vector of dominance covariances due to non-random mating}
\item{covAA_HW}{an nTrait vector of additive-by-additive covariances due to non-random mating}
\item{covG_HW}{an nTrait vector of total genic covariances due to non-random mating}
\item{covA_L}{an nTrait vector of additive covariances due to linkage disequilibrium}
\item{covD_L}{an nTrait vector of dominance covariances due to linkage disequilibrium}
\item{covAA_L}{an nTrait vector of additive-by-additive covariances due to linkage disequilibrium}
\item{covAD_L}{an nTrait vector of additive by dominance covariances due to linkage disequilibrium}
\item{covAAA_L}{an nTrait vector of additive by additive-by-additive covariances due to linkage disequilibrium}
\item{covDAA_L}{an nTrait vector of dominance by additive-by-additive covariances due to linkage disequilibrium}
\item{covG_L}{an nTrait vector of total genic covariances due to linkage disequilibrium}
\item{mu}{an nTrait vector of trait means}
\item{mu_HW}{an nTrait vector of expected trait means under random mating}
\item{gv}{a matrix of genetic values with dimensions nInd by nTraits}
\item{bv}{a matrix of breeding values with dimensions nInd by nTraits}
\item{dd}{a matrix of dominance deviations with dimensions nInd by nTraits}
\item{aa}{a matrix of additive-by-additive epistatic deviations with dimensions nInd by nTraits}
\item{gv_mu}{an nTrait vector of intercepts with dimensions nInd by nTraits}
\item{gv_a}{a matrix of additive genetic values with dimensions nInd by nTraits}
\item{gv_d}{a matrix of dominance genetic values with dimensions nInd by nTraits}
\item{gv_aa}{a matrix of additive-by-additive genetic values with dimensions nInd by nTraits}
\item{alpha}{a list of average allele subsitution effects with length nTraits}
\item{alpha_HW}{a list of average allele subsitution effects at Hardy-Weinberg equilibrium with length nTraits}
}
}
\description{
Calculates genetic and genic additive and dominance variances
for an object of \code{\link{Pop-class}}
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitAD(10, meanDD=0.5)
SP$setVarE(h2=0.5)
\dontshow{SP$nThreads = 1L}

#Create population
pop = newPop(founderPop, simParam=SP)
ans = genParam(pop, simParam=SP)

}
