% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.r
\docType{data}
\name{amiga_palettes}
\alias{amiga_palettes}
\title{Commonly used palettes on the Commodore Amiga}
\format{
{
A named list with the following elements:
\itemize{
\item \code{wb.os1}: A \code{vector} of 4 colours that were used as the default
palette of the Workbench on Amiga OS 1.x.
\item \code{wb.os2}: A \code{vector} of 8 colours. The first 4 colours are the default
colours of a standard Workbench on Amiga OS 2.x. The latter 4 are additional
colours used by the Workbench expansion MagicWB.
\item \code{spr.os1}: A \code{vector} of 3 colours that were used by default
for a mouse pointer sprite on Amiga OS 1.x.
\item \code{spr.os2}: A \code{vector} of 3 colours that were used by default
for a mouse pointer sprite on Amiga OS 2.x.}
}
}
\description{
\code{amiga_palettes} is a named list, where each element represents a commonly
used palette on the Commodore Amiga.
}
\details{
Some files that contain bitmap images with an indexed palette did not store the
palette in the same file. Amiga Workbench icons (\code{\link[=AmigaIcon]{AmigaIcon()}}) for instance
only store the index values of the palette, but not the palette itself.
\code{amiga_palettes} therefore provides some commonly used palettes on the Amiga,
such that these files can be interpreted.
}
\examples{
data("amiga_palettes")
}
