% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annoGene.R
\name{annoGene}
\alias{annoGene}
\title{Annotate gene IDs according to GTF files in gencode}
\usage{
annoGene(IDs, ID_type, species = "human", out_file)
}
\arguments{
\item{IDs}{a list of genes}

\item{ID_type}{the type of input IDs, should be "ENSEMBL" or "SYMBOL"}

\item{species}{choose human or mouse, or rat, default: human}

\item{out_file}{the filename, should be ".csv" or ".html".}
}
\value{
a dataframe which columns contain genesymbol, biotypes, ensembl ids and the positions of genes
}
\description{
annoGene will return a data.frame of gene information or write them to a file (csv or html format).
The user should set a list of genes to be annotated, with  "ENSEMBL" or "SYMBOL" style.
}
\examples{
IDs <- c("DDX11L1", "MIR6859-1", "OR4G4P", "OR4F5")
ID_type = "SYMBOL"
annoGene(IDs, ID_type)
\donttest{
annoGene(IDs, ID_type,out_file = tempfile(fileext = ".html"))
annoGene(IDs, ID_type,out_file = tempfile(fileext = ".csv"))
}
}
