% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{AM_VnkPoisson}
\alias{AM_VnkPoisson}
\title{Compute the value V(n,k), needed to caclulate the eppf of a Finite Dirichlet process when the prior on the component-weigts of the mixture is a Dirichlet with parameter \code{gamma} (i.e. when unnormailized weights are distributed as Gamma(\eqn{\gamma},1) ) when the prior on the number of componet is Shifted Poisson of parameter \code{Lambda}. See Section 9.1.1 of the Paper Argiento de Iorio 2019.}
\usage{
AM_VnkPoisson(n, Lambda, gamma)
}
\arguments{
\item{n}{The sample size}

\item{Lambda}{The \code{Lambda} parameter of the Poisson}

\item{gamma}{The \code{gamma} parameter of the Dirichlet}
}
\value{
A vector of length n, reporting the values \code{V(n,k)} for \code{k=1,...,n}
}
\description{
There are no default values.
}
\examples{
n=1000
Lam=100
gam=0.5
vnk= AM_VnkPoisson(n,Lam,gam)
stir= AM_compute_stirling_ricor_log(n, gam)
plot(exp(vnk+stir))
sum(exp(vnk+stir ))
}
\keyword{cluster}
\keyword{number}
\keyword{of}
\keyword{prior}
