% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AM_mix_hyperparams.R
\name{AM_mix_hyperparams_unipois}
\alias{AM_mix_hyperparams_unipois}
\title{univariate Poisson mixture hyperparameters}
\usage{
AM_mix_hyperparams_unipois(alpha0, beta0)
}
\arguments{
\item{alpha0}{The shape  hyperparameter \eqn{\alpha_0}.}

\item{beta0}{The  rate hyperparameter \eqn{\beta_0}.}
}
\value{
An \code{\link{AM_mix_hyperparams}} object. This is a configuration list to be used as \code{mix_kernel_hyperparams} argument for \code{\link{AM_mcmc_fit}}.
}
\description{
Generate a configuration object that specifies a univariate Poisson mixture kernel, where users can
specify the hyperparameters of the conjugate Gamma prior, i.e. the kernel is a \eqn{Poisson(\tau) }
and \eqn{\tau\sim Gamma(\alpha_0,\beta_0)}.
In AntMAN we assume the following
parametrization of the Gamma density:
\deqn{p(x\mid a,b )= \frac{b^a x^{a-1}}{\Gamma(a)} \exp\{ -bx \}, \quad x>0.}
}
\details{
Note that by default, alpha0=1 and beta0=1.
}
\examples{
AM_mix_hyperparams_unipois (alpha0=2, beta0=0.2)
}
