% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AM_prior.R
\name{AM_prior_K_NegBin}
\alias{AM_prior_K_NegBin}
\title{computes the prior number of clusters}
\usage{
AM_prior_K_NegBin(n, gamma, r, p)
}
\arguments{
\item{n}{The sample size.}

\item{gamma}{The \code{gamma} parameter of the Dirichlet distribution.}

\item{r}{The dispersion parameter \code{r} of the Negative Binomial.}

\item{p}{The probability of failure parameter \code{p} of the Negative Binomial.}
}
\value{
an \code{\link{AM_prior}} object, that is a vector of length n, reporting the values \code{V(n,k)} for \code{k=1,...,n}.
}
\description{
This function computes the prior on the number of clusters, i.e. occupied component of the mixture for a Finite Dirichlet process when the
prior on the component-weights of the mixture is a Dirichlet with parameter \code{gamma} (i.e. when unnormalized weights are distributed as
Gamma(\eqn{\gamma},1)). This function can be used when the prior on the number of components is Negative Binomial with parameter \eqn{r>0} and
\eqn{0<p<1}, with mean \eqn{mu =1+ r*p/(1-p)}. See \insertCite{argiento2019infinity}{AntMAN} for more details.
}
\details{
There are no default values.
}
\examples{
n <- 50
gamma <- 1
r <- 0.1
p <- 0.91
gam_nb <- 0.2381641
prior_K_nb <-  AM_prior_K_NegBin(n,gam_nb,r,p)
plot(prior_K_nb)
}
\keyword{cluster}
\keyword{number}
\keyword{of}
\keyword{prior}
