% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Apollonius.R
\name{Apollonius}
\alias{Apollonius}
\title{Apollonius diagram and Apollonius graph}
\usage{
Apollonius(sites, radii, tmax = 30, nsegs = 100L, nrays = 300L)
}
\arguments{
\item{sites}{the 2D points, a numeric matrix with two columns (one point
per row)}

\item{radii}{the weights, a numeric vector of length equal to the number of
points (i.e. the number of rows of \code{sites})}

\item{tmax}{a positive number passed to \code{\link[gyro]{gyroray}},
controlling the length of the infinite edges (i.e. the hyperbolic rays)
of the Apollonius graph}

\item{nsegs}{a positive integer, the desired number of points of each
finite edge of the Apollonius graph}

\item{nrays}{a positive integer, the desired number of points of each
infinite edge of the Apollonius graph}
}
\value{
A list with two fields \code{diagram} and \code{graph}. The
  \code{diagram} field is a list providing the sites and the faces of the
  Apollonius diagram. The \code{graph} field is a list providing the sites
  and the edges of the Apollonius graph.
}
\description{
Computation of the Apollonius diagram and the Apollonius graph
  of some weighted 2D points. The Apollonius graph is the dual of the
  Apollonius diagram. It is also called the additively weighted Voronoï
  diagram.
}
\details{
See the \href{https://doc.cgal.org/latest/Apollonius_graph_2/index.html#Chapter_2D_Apollonius_Graphs}{CGAL documentation}.
}
\examples{
library(Apollonius)
sites <- rbind(
  c(0, 0),
  c(4, 1),
  c(2, 4),
  c(7, 4),
  c(8, 0),
  c(5, -2),
  c(-4, 4),
  c(-2, -1),
  c(11, 4),
  c(11, 0)
)
radii <- c(1, 1.5, 1.25, 2, 1.75, 0.5, 0.4, 0.6, 0.7, 0.3)
apo <- Apollonius(sites, radii)
opar <- par(mar = c(4, 4, 1, 1))
plotApolloniusGraph(apo, xlab = "x", ylab = "y")
par(opar)

# Example of a non-valid graph ####
library(Apollonius)
sites <- rbind(
  c(-1, -1),
  c(-1, 1),
  c(1, 1),
  c(1, -1),
  c(0, 0)
)
angle_ <- seq(0, 2*pi, length.out = 13L)[-1L]
circle <- cbind(2 * cos(angle_), 2 * sin(angle_))
sites <- rbind(sites, circle)
radii <- c(rep(2, 5), rep(1, 12))
\donttest{apo <- Apollonius(sites, radii)}
}
