% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcWatBal.R
\name{calcWatBal}
\alias{calcWatBal}
\title{Soil Water Balance}
\usage{
calcWatBal(data, soilWHC)
}
\arguments{
\item{data}{a dataframe containing the required variables: Columns must
contain the following parameters:

\if{html}{\out{<div class="sourceCode">}}\preformatted{   Lat: latitude of the site in decimal degrees.
   Lon: longitude of the site in decimal degrees.
   Elev: elevation above sea level in (meters).
   Year: year of record "YYYY".
   Month: month of record "MM".
   Day: day of record "DD".
   Rain: daily rainfall in (mm).
   Eto: daily potential evapotranspiration in (mm).
}\if{html}{\out{</div>}}}

\item{soilWHC}{\verb{  }Water holding capacity of the soil in (mm).}
}
\value{
The function generates a data frame containing the following
components:

\emph{\code{DRAIN: amount of deep drainage in (mm).}}

\emph{\code{TRAN: amount of water lost by transpiration in (mm).}}

\emph{\code{RUNOFF: surface runoff in (mm).}}

\emph{\code{AVAIL: available soil moisture storage in (mm).}}

\emph{\code{R: actual-to-potential evapotranspiration ratio.}}
}
\description{
Function to estimate a budget-based daily soil water balance.
It calculates the amount of water present in the root zone of a homogeneous
grass canopy growing on a well-drained and homogeneous soil.
}
\examples{

\donttest{
# load example data:
data(AgroClimateData)

# Estimate daily PET:
PET <- calcEto(AgroClimateData, method = "PM", Zh = 10)

# Add the estimated PET 'ET.Daily' to a new column in AgroClimateData:
AgroClimateData$Eto <- PET$ET.Daily

# Estimate daily water balance for the soil having 100mm of WHC:
watBal<- calcWatBal(AgroClimateData, soilWHC = 100)

# Visualizing water balance parameters for 2019/20 season
watBal.19T20 <- watBal[watBal$Year \%in\% c(2019, 2020),]
date.vec <- as.Date.character(paste0(watBal.19T20$Year, "-",
                                     watBal.19T20$Month, "-",
                                     watBal.19T20$Day))

plot(y = watBal.19T20$AVAIL, x = date.vec, ty="l", col="black", xlab="",
ylab=" Water (mm)",
       main="Daily Water Balance Parameters", lwd = 1, lty = 2)
 lines(y = watBal.19T20$Eto, x = date.vec, col="red", lwd = 3, lty = 1)
 lines(y = watBal.19T20$Rain, x = date.vec, col="blue", lwd = 1, lty = 1)

  legend("bottomright",c("Rain","Eto","Available Moisture"),
        horiz=FALSE, bty='n', cex=1.2,lty=c(1,1,2),lwd=c(1,3,1),
        inset=c(0,0.7),
        xpd=TRUE, col=c("blue","red","black"))
}
}
\references{
Allen, R.G.; Pereira, L.S.; Raes, D.; Smith, M. Crop
Evapotranspiration: Guidelines for Computing Crop Water Requirements; FAO
Irrigation and Drainage Paper no. 56; FAO: Rome, Italy, 1998;
ISBN 92-5-104219-5.

Doorenbos, J. and Pruitt, W.O. 1975. Guidelines for predicting crop water
requirements, Irrigation and Drainage Paper 24, Food and Agriculture
Organization of the United Nations, Rome, 179 p.
}
\seealso{
\code{\link{calcEto}, \link{calcSeasCal}}
}
